/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.lines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class GeneralizedCoastlineCheck
extends BaseCheck<Long> {
    private static final String BASIC_INSTRUCTIONS = "This coastline is generalized, as {0}% of node pairs are {1} or more apart. To fix, add more nodes to this coastline. The midpoints of generalized segments are dotted for convenience.";
    private static final String SHARP_ANGLE_INSTRUCTIONS = "This coastline is generalized, as {0}% of node pairs are {1} or more apart. There are also sharp angles exceeding {2} degrees. To fix, add more nodes to smooth angles and break up long segments of coastline. Suggested areas to add nodes are dotted.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This coastline is generalized, as {0}% of node pairs are {1} or more apart. To fix, add more nodes to this coastline. The midpoints of generalized segments are dotted for convenience.", "This coastline is generalized, as {0}% of node pairs are {1} or more apart. There are also sharp angles exceeding {2} degrees. To fix, add more nodes to smooth angles and break up long segments of coastline. Suggested areas to add nodes are dotted.");
    private static final double MINIMUM_DISTANCE_BETWEEN_NODES = 100.0;
    private static final double MINIMUM_NODE_PAIR_THRESHOLD_PERCENTAGE = 30.0;
    private static final String COASTLINE_TAG_FILTER_DEFAULT = "source->PGS";
    private static final double SHARP_ANGLE_THRESHOLD_DEFAULT = 2.147483647E9;
    private static final double HUNDRED_PERCENT = 100.0;
    private static final long serialVersionUID = 1576217971819771231L;
    private final double percentageThreshold;
    private final Distance minimumDistanceBetweenNodes;
    private final TaggableFilter coastlineTagFilter;
    private final Angle sharpAngleThreshold;
    private final double sharpAngleDegrees;

    public GeneralizedCoastlineCheck(Configuration configuration) {
        super(configuration);
        this.percentageThreshold = this.configurationValue(configuration, "node.minimum.threshold", 30.0);
        this.minimumDistanceBetweenNodes = this.configurationValue(configuration, "node.minimum.distance", 100.0, Distance::meters);
        this.coastlineTagFilter = this.configurationValue(configuration, "coastline.tags.filters", COASTLINE_TAG_FILTER_DEFAULT, TaggableFilter::forDefinition);
        this.sharpAngleDegrees = this.configurationValue(configuration, "angle.minimum.threshold", 2.147483647E9);
        this.sharpAngleThreshold = Angle.degrees(this.sharpAngleDegrees);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Predicate<Relation> memberIsCoastline = this::isCoastline;
        Predicate<Relation> memberIsSourcePGS = this.coastlineTagFilter::test;
        return object instanceof LineItem && (this.isCoastline(object) && this.coastlineTagFilter.test(object) || this.hasRelationMembers(object, memberIsCoastline) && this.hasRelationMembers(object, memberIsSourcePGS));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        double generalizedSegments = this.getGeneralizedSegmentPercentage((LineItem)object);
        if (generalizedSegments >= this.percentageThreshold) {
            List<Location> pointsForFlagging = this.getPointsForFlagging((LineItem)object);
            List<Location> sharpAngles = this.getSharpAngleLocations((LineItem)object);
            if (!sharpAngles.isEmpty() && this.sharpAngleDegrees != 2.147483647E9) {
                pointsForFlagging.addAll(sharpAngles);
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, generalizedSegments, this.minimumDistanceBetweenNodes, this.sharpAngleThreshold.asDegrees()), pointsForFlagging));
            }
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, generalizedSegments, this.minimumDistanceBetweenNodes), pointsForFlagging));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private double getGeneralizedSegmentPercentage(LineItem line) {
        List<Segment> segments = line.asPolyLine().segments();
        double innerCount = segments.stream().filter(segment -> segment.length().isGreaterThanOrEqualTo(this.minimumDistanceBetweenNodes)).count();
        return segments.isEmpty() ? 0.0 : 100.0 * (innerCount / (double)segments.size());
    }

    private List<Location> getPointsForFlagging(LineItem line) {
        return line.asPolyLine().segments().stream().filter(segment -> segment.length().asMeters() >= this.minimumDistanceBetweenNodes.asMeters()).map(segment -> segment.start().midPoint(segment.end())).collect(Collectors.toList());
    }

    private List<Location> getSharpAngleLocations(LineItem coast) {
        List<Tuple<Angle, Location>> offendingAngles = coast.asPolyLine().anglesGreaterThanOrEqualTo(this.sharpAngleThreshold);
        if (!offendingAngles.isEmpty()) {
            ArrayList<Location> resultList = new ArrayList<Location>();
            offendingAngles.forEach(tuple -> resultList.add((Location)tuple.getSecond()));
            return resultList;
        }
        return Collections.emptyList();
    }

    private boolean hasRelationMembers(AtlasObject object, Predicate<Relation> relationPredicate) {
        return ((LineItem)object).relations().stream().anyMatch(relationPredicate);
    }

    private boolean isCoastline(AtlasObject object) {
        return Validators.isOfType((Taggable)object, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.COASTLINE});
    }
}

