/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.validation.linear.edges.SnakeRoadNetworkWalk;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class SnakeRoadCheck
extends BaseCheck<Long> {
    private static final Angle EDGE_HEADING_DIFFERENCE_THRESHOLD = Angle.degrees(60.0);
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The way with id {0,number,#} is a snake road. Consider spliting it into two or more separate ways.");
    private static final long MINIMUM_EDGES_TO_QUALIFY_AS_SNAKE_ROAD = 3L;
    private static final long MINIMUM_VALENCE_TO_QUALIFY_AS_SNAKE_ROAD = 4L;
    private static final long serialVersionUID = 6040648590412505891L;

    private static boolean isValidEdgeToConsider(Edge candidate) {
        return candidate.isMasterEdge() && candidate.highwayTag().isMoreImportantThanOrEqualTo(HighwayTag.RESIDENTIAL) && candidate.highwayTag().isLessImportantThan(HighwayTag.TRUNK_LINK) && !JunctionTag.isRoundabout(candidate) && !TagPredicates.IS_HIGHWAY_AREA.test(candidate) && candidate.isWaySectioned();
    }

    public SnakeRoadCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && TypePredicates.IS_EDGE.test(object) && SnakeRoadCheck.isValidEdgeToConsider((Edge)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        this.markAsFlagged(object.getOsmIdentifier());
        SnakeRoadNetworkWalk walk = this.initializeNetworkWalk(edge);
        this.walkNetwork(edge, walk);
        if (this.networkWalkQualifiesAsSnakeRoad(walk)) {
            return Optional.of(this.createFlag(walk.getVisitedEdges(), this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private SnakeRoadNetworkWalk initializeNetworkWalk(Edge edge) {
        SnakeRoadNetworkWalk walk = new SnakeRoadNetworkWalk(edge, EDGE_HEADING_DIFFERENCE_THRESHOLD);
        walk.addDirectConnections(walk.getConnectedMasterEdgeOfTheSameWay(edge));
        return walk;
    }

    private boolean networkWalkQualifiesAsSnakeRoad(SnakeRoadNetworkWalk walk) {
        return walk.isSnakeRoad() && (long)walk.getVisitedEdges().size() >= 3L && walk.getGreatestEncounteredValence() > 4L;
    }

    private void walkNetwork(Edge current, SnakeRoadNetworkWalk walk) {
        while (!walk.getDirectConnections().isEmpty()) {
            Edge connection = walk.getDirectConnections().poll();
            walk.visitEdge(current, connection);
            Set<Edge> oneLayerRemovedConnections = walk.getConnectedMasterEdgeOfTheSameWay(connection);
            oneLayerRemovedConnections.forEach(onceRemovedConnection -> walk.checkIfEdgeHeadingDifferenceExceedsThreshold(connection, (Edge)onceRemovedConnection));
            walk.populateOneLayerRemovedConnections(oneLayerRemovedConnections);
            if (!walk.getDirectConnections().isEmpty()) continue;
            if (walk.getOneLayerRemovedConnections().isEmpty()) {
                walk.filterFalsePositives();
                continue;
            }
            walk.addDirectConnections(walk.getOneLayerRemovedConnections());
            walk.clearOneLayerRemovedConnections();
        }
    }
}

