/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class LongSegmentCheck
extends BaseCheck<Long> {
    public static final double DISTANCE_MINIMUM_KILOMERTERS_DEFAULT = 10.0;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Way {0,number,#} has a very long stretch with no nodes in it (length = {1} km). This may not be an accurate representation of ground truth.");
    private static final long serialVersionUID = -3153236856904455996L;
    private final Distance minimumLength;

    public LongSegmentCheck(Configuration configuration) {
        super(configuration);
        this.minimumLength = this.configurationValue(configuration, "length.minimum.kilometers", 10.0, Distance::kilometers);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMasterEdge() && !Validators.isOfType((Taggable)object, RouteTag.class, (Enum[])new RouteTag[]{RouteTag.FERRY});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        Optional<Segment> segment = edge.asPolyLine().segments().stream().filter(s2 -> s2.length().isGreaterThanOrEqualTo(this.minimumLength)).findFirst();
        if (segment.isPresent()) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, edge.getOsmIdentifier(), segment.get().length().asKilometers())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

