/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.AmenityTag;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.LevelTag;
import org.openstreetmap.atlas.tags.ManMadeTag;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class InvalidPiersCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 6011101860745289836L;
    private static final String LINEAR_GEOMETRY_WITH_HIGHWAY_TAG = "This way {0,number,#} is a linear pier with \"man_made=pier\"tag and a highway tag. Please make necessary changes to convert its geometry to a polygon and add tag, \"area=yes\".";
    private static final String POLYGONAL_GEOMETRY_WITH_BUILDING_AND_HIGHWAY_TAG = "This way {0,number,#} is a ferry terminal or a building or a highway with \"man_made=pier\" tag and has a polygonal geometry, but is missing \"area=yes\" tag. Please add tag \"area=yes\" to the pier.";
    private static final String LINEAR_GEOMETRY_WITH_OVERLAPPING_HIGHWAY_AND_BUILDING = "This way {0,number,#} is a linear pier with \"man_made=pier\" tag and has either overlapping highways or buildings or is connected to buildings or ferry routes or both. Please make necessary changes to convert its geometry to a polygon and add tag, \"area=yes\".";
    private static final String POLYGONAL_GEOMETRY_WITH_OVERLAPPING_HIGHWAY_AND_BUILDING = "This way {0,number,#} is a polygonal pier with \"man_made=pier\" tag and has either overlapping highways or buildings or is connected to buildings or ferry routes or both, but is missing \"area=yes\" tag. Please add tag \"area=yes\" to the pier.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This way {0,number,#} is a linear pier with \"man_made=pier\"tag and a highway tag. Please make necessary changes to convert its geometry to a polygon and add tag, \"area=yes\".", "This way {0,number,#} is a ferry terminal or a building or a highway with \"man_made=pier\" tag and has a polygonal geometry, but is missing \"area=yes\" tag. Please add tag \"area=yes\" to the pier.", "This way {0,number,#} is a linear pier with \"man_made=pier\" tag and has either overlapping highways or buildings or is connected to buildings or ferry routes or both. Please make necessary changes to convert its geometry to a polygon and add tag, \"area=yes\".", "This way {0,number,#} is a polygonal pier with \"man_made=pier\" tag and has either overlapping highways or buildings or is connected to buildings or ferry routes or both, but is missing \"area=yes\" tag. Please add tag \"area=yes\" to the pier.");
    private static final Predicate<AtlasObject> HAS_NO_AREA_TAG = atlasObject -> !Validators.isOfType((Taggable)atlasObject, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES});
    private static final Predicate<AtlasObject> IS_FERRY_TERMINAL = atlasObject -> Validators.isOfType((Taggable)atlasObject, AmenityTag.class, (Enum[])new AmenityTag[]{AmenityTag.FERRY_TERMINAL});
    private static final Predicate<AtlasObject> IS_BUILDING = atlasObject -> Validators.hasValuesFor(atlasObject, BuildingTag.class);
    private static final String MINIMUM_HIGHWAY_TYPE_OVERLAPPING_EDGE_DEFAULT = HighwayTag.TOLL_GANTRY.toString();
    private static final String MINIMUM_HIGHWAY_TYPE_PIER_DEFAULT = HighwayTag.TOLL_GANTRY.toString();
    private static final int INSTRUCTION_INDEX_0 = 0;
    private static final int INSTRUCTION_INDEX_1 = 1;
    private static final int INSTRUCTION_INDEX_2 = 2;
    private static final int INSTRUCTION_INDEX_3 = 3;
    private final HighwayTag minimumHighwayTypeOverlappingEdge;
    private final HighwayTag minimumHighwayTypePier;

    public InvalidPiersCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayTypeOverlappingEdge = this.configurationValue(configuration, "highway.type.minimum.overlapping", MINIMUM_HIGHWAY_TYPE_OVERLAPPING_EDGE_DEFAULT, configValue -> HighwayTag.valueOf(configValue.toUpperCase()));
        this.minimumHighwayTypePier = this.configurationValue(configuration, "highway.type.minimum.pier", MINIMUM_HIGHWAY_TYPE_PIER_DEFAULT, configValue -> HighwayTag.valueOf(configValue.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMasterEdge() && ManMadeTag.isPier(object) && HAS_NO_AREA_TAG.test(object) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected boolean acceptPier() {
        return true;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        this.markAsFlagged(edge.getOsmIdentifier());
        Set edgesFormingOSMWay = new OsmWayWalker(edge).collectEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
        ArrayList<Edge> listOfEdgesFormingOSMWay = new ArrayList<Edge>(edgesFormingOSMWay);
        listOfEdgesFormingOSMWay.sort(Comparator.comparingLong(AtlasObject::getIdentifier));
        HashSet<Location> locationsInOsmWay = new HashSet<Location>();
        listOfEdgesFormingOSMWay.forEach(osmWayEdge -> locationsInOsmWay.addAll(osmWayEdge.asPolyLine()));
        Polygon osmWayAsPolygon = new Polygon((Iterable<Location>)locationsInOsmWay);
        boolean isPolygonal = this.hasPolygonalGeometry(listOfEdgesFormingOSMWay, edge);
        if (HighwayTag.highwayTag(edge).isPresent() && HighwayTag.highwayTag(edge).get().isMoreImportantThanOrEqualTo(this.minimumHighwayTypePier) || isPolygonal && IS_BUILDING.test(edge) || isPolygonal && IS_FERRY_TERMINAL.test(edge)) {
            int instructionIndex = isPolygonal ? 1 : 0;
            return Optional.of(this.createFlag(edgesFormingOSMWay, this.getLocalizedInstruction(instructionIndex, object.getOsmIdentifier())));
        }
        boolean isConnectedToFerryOrBuilding = this.isConnectedToFerryOrBuilding(edge, listOfEdgesFormingOSMWay, isPolygonal, osmWayAsPolygon);
        boolean overlapsHighway = this.pierOverlapsHighway(edge, listOfEdgesFormingOSMWay, osmWayAsPolygon, isPolygonal);
        int instructionIndex = isPolygonal ? 3 : 2;
        return overlapsHighway || isConnectedToFerryOrBuilding ? Optional.of(this.createFlag(edgesFormingOSMWay, this.getLocalizedInstruction(instructionIndex, object.getOsmIdentifier()))) : Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean areOnSameLevelOrLayer(AtlasObject objectOne, Edge objectTwo) {
        return LayerTag.areOnSameLayer(objectOne, objectTwo) && LevelTag.areOnSameLevel(objectOne, objectTwo);
    }

    private boolean hasPolygonalGeometry(List<Edge> edgesFormingOSMWay, Edge originalEdge) {
        if (edgesFormingOSMWay.size() == 1 && originalEdge.start().equals(originalEdge.end()) && originalEdge.length().isGreaterThan(Distance.ZERO)) {
            return true;
        }
        HashSet<Long> wayIds = new HashSet<Long>();
        Edge nextEdge = originalEdge;
        while (nextEdge != null) {
            wayIds.add(nextEdge.getIdentifier());
            List<Edge> nextEdgeList = Iterables.stream(nextEdge.outEdges()).filter(outEdge -> outEdge.isMasterEdge() && outEdge.getOsmIdentifier() == originalEdge.getOsmIdentifier()).collectToList();
            if ((nextEdge = nextEdgeList.isEmpty() ? null : nextEdgeList.get(0)) == null || !wayIds.contains(nextEdge.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectedToFerryOrBuilding(Edge originalEdge, List<Edge> edgesOfOSMWay, boolean isPolygonal, Polygon polygon) {
        Atlas atlas = originalEdge.getAtlas();
        boolean intersectsFerryRoute = edgesOfOSMWay.stream().anyMatch(eachEdge -> eachEdge.connectedEdges().stream().filter(connectedEdge -> this.areOnSameLevelOrLayer((AtlasObject)connectedEdge, originalEdge)).anyMatch(RouteTag::isFerry));
        boolean intersectsBuilding = isPolygonal ? edgesOfOSMWay.stream().anyMatch(eachEdge -> Iterables.stream(atlas.areasIntersecting(eachEdge.bounds(), intersectingArea -> !(!polygon.fullyGeometricallyEncloses(intersectingArea.asPolygon()) && !intersectingArea.asPolygon().intersects(eachEdge.asPolyLine()) || !this.areOnSameLevelOrLayer((AtlasObject)intersectingArea, originalEdge) || !IS_BUILDING.test((AtlasObject)intersectingArea) && !IS_FERRY_TERMINAL.test((AtlasObject)intersectingArea)))).iterator().hasNext()) : edgesOfOSMWay.stream().anyMatch(eachEdge -> Iterables.stream(atlas.areasIntersecting(eachEdge.bounds(), intersectingArea -> intersectingArea.asPolygon().intersects(eachEdge.asPolyLine()) && this.areOnSameLevelOrLayer((AtlasObject)intersectingArea, originalEdge) && (IS_BUILDING.test((AtlasObject)intersectingArea) || IS_FERRY_TERMINAL.test((AtlasObject)intersectingArea)))).iterator().hasNext());
        return intersectsFerryRoute || intersectsBuilding;
    }

    private boolean linearPierOverlapsHighway(Edge intersectingEdge, List<Edge> edgesFormingOSMWay) {
        return edgesFormingOSMWay.stream().anyMatch(connectedEdge -> connectedEdge.asPolyLine().overlapsShapeOf(intersectingEdge.asPolyLine()));
    }

    private boolean pierOverlapsHighway(AtlasObject originalEdge, List<Edge> edgesFormingOSMWay, Polygon osmWayAsPolygon, boolean isPolygonal) {
        return Iterables.stream(originalEdge.getAtlas().edgesIntersecting(osmWayAsPolygon)).filter(intersectingEdge -> intersectingEdge.getOsmIdentifier() != originalEdge.getOsmIdentifier()).anyMatch(intersectingEdge -> intersectingEdge.isMasterEdge() && HighwayTag.highwayTag(intersectingEdge).isPresent() && HighwayTag.highwayTag(intersectingEdge).get().isMoreImportantThanOrEqualTo(this.minimumHighwayTypeOverlappingEdge) && this.areOnSameLevelOrLayer(originalEdge, (Edge)intersectingEdge) && (isPolygonal ? this.polygonalPierOverlapsHighway((Edge)intersectingEdge, osmWayAsPolygon) : this.linearPierOverlapsHighway((Edge)intersectingEdge, edgesFormingOSMWay)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean polygonalPierOverlapsHighway(Edge intersectingEdge, Polygon osmWayAsPolygon) {
        if (intersectingEdge.asPolyLine().overlapsShapeOf(osmWayAsPolygon)) return true;
        if (!intersectingEdge.asPolyLine().segments().stream().anyMatch(osmWayAsPolygon::fullyGeometricallyEncloses)) return false;
        return true;
    }
}

