/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.FootTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.OneWayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.NameTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.direction.EdgeDirectionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnwalkableWaysCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -2894765496856223796L;
    private static final Logger logger = LoggerFactory.getLogger(UnwalkableWaysCheck.class);
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Way {0,number,#} may be unwalkable and needs verification if safe pedestrian crossing exists. If it does, it should be marked \u2018foot=yes\u2019. If safe pedestrian crossing does not exist, the Way should be marked \u2018foot=no'.");
    private static final HighwayTag MINIMUM_HIGHWAY_TYPE_DEFAULT = HighwayTag.PRIMARY;
    private static final List<String> DEFAULT_WALKWAY_TAGS = Arrays.asList(HighwayTag.CYCLEWAY.toString(), HighwayTag.FOOTWAY.toString(), HighwayTag.PATH.toString(), HighwayTag.STEPS.toString(), HighwayTag.PEDESTRIAN.toString(), HighwayTag.LIVING_STREET.toString());
    private static final EdgeDirectionComparator EDGE_DIRECTION_COMPARATOR = new EdgeDirectionComparator();
    private final Boolean includeDualCrossingDualCarriageways;
    private final HighwayTag minimumHighwayType;
    private final HighwayTag[] walkwayTags;

    public UnwalkableWaysCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_TYPE_DEFAULT.toString(), tag -> HighwayTag.valueOf(tag.toUpperCase()));
        this.walkwayTags = (HighwayTag[])this.configurationValue(configuration, "walkway.tags", DEFAULT_WALKWAY_TAGS).stream().map(value -> HighwayTag.valueOf(value.toUpperCase())).toArray(HighwayTag[]::new);
        this.includeDualCrossingDualCarriageways = this.configurationValue(configuration, "includeDualCrossingDualCarriageways", false);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        if (!(object instanceof Edge)) {
            return false;
        }
        Edge edge = (Edge)object;
        return edge.isMasterEdge() && edge.connectedNodes().stream().noneMatch(node -> Validators.isOfType((Taggable)node, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CROSSING})) && !Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY, HighwayTag.MOTORWAY_LINK}) && !Validators.isOfType((Taggable)edge, FootTag.class, (Enum[])new FootTag[]{FootTag.YES, FootTag.NO}) && !Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])this.walkwayTags) && !edge.getTag("sidewalk").isPresent();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge crossingEdge = (Edge)object;
        Set<Edge> startEdges = this.filterConnectedEdgesToCandidates(crossingEdge.start().connectedEdges(), crossingEdge);
        Set<Edge> endEdges = this.filterConnectedEdgesToCandidates(crossingEdge.end().connectedEdges(), crossingEdge);
        for (Edge matchingStartEdge : startEdges) {
            Optional<String> matchingStartEdgeName = NameTag.getNameOf(matchingStartEdge);
            Optional<HighwayTag> matchingStartEdgeHighwayTag = HighwayTag.highwayTag(matchingStartEdge);
            Optional<Edge> matchingEndEdge = endEdges.stream().filter(potentialMatchingEndEdge -> {
                Boolean tagsAndIdsMatch = matchingStartEdge.getIdentifier() != potentialMatchingEndEdge.getIdentifier() && matchingStartEdgeName.isPresent() && matchingStartEdgeName.equals(NameTag.getNameOf(potentialMatchingEndEdge)) && matchingStartEdgeHighwayTag.equals(HighwayTag.highwayTag(potentialMatchingEndEdge));
                Boolean oppositeDirection = EDGE_DIRECTION_COMPARATOR.isOppositeDirection(matchingStartEdge, (Edge)potentialMatchingEndEdge, false);
                return tagsAndIdsMatch != false && oppositeDirection != false;
            }).findFirst();
            if (!matchingEndEdge.isPresent()) continue;
            if (!this.includeDualCrossingDualCarriageways.booleanValue() && this.hasReverseCarriageway(crossingEdge)) {
                logger.trace("Skipping {} as possible dual carriageway.", (Object)matchingEndEdge.get().getOsmIdentifier());
                return Optional.empty();
            }
            logger.info("Flagging {}", (Object)crossingEdge.getOsmIdentifier());
            CheckFlag flag = this.createFlag((AtlasObject)crossingEdge, this.getLocalizedInstruction(0, crossingEdge.getOsmIdentifier()));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Set<Edge> filterConnectedEdgesToCandidates(Set<Edge> edges, Edge originalEdge) {
        Optional<String> originalEdgeName = NameTag.getNameOf(originalEdge);
        return edges.stream().filter(candidate -> {
            Optional<String> candidateEdgeName = NameTag.getNameOf(candidate);
            return !originalEdgeName.equals(candidateEdgeName) && !OneWayTag.isTwoWay(candidate) && candidate.highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayType);
        }).collect(Collectors.toSet());
    }

    private boolean hasReverseCarriageway(Edge originalEdge) {
        Set<Edge> firstLevel = originalEdge.connectedEdges();
        HashSet secondLevel = new HashSet();
        firstLevel.forEach(firstLevelEdge -> secondLevel.addAll(firstLevelEdge.connectedEdges()));
        Set visitedEdgeIds = firstLevel.stream().map(AtlasObject::getIdentifier).collect(Collectors.toSet());
        visitedEdgeIds.add(originalEdge.getIdentifier());
        Set filteredSecondLevel = secondLevel.stream().filter(secondLevelEdge -> !visitedEdgeIds.contains(secondLevelEdge.getIdentifier())).collect(Collectors.toSet());
        return filteredSecondLevel.stream().anyMatch(filteredSecondLevelEdge -> NameTag.getNameOf(filteredSecondLevelEdge).equals(NameTag.getNameOf(originalEdge)) && filteredSecondLevelEdge.getTag("highway").equals(originalEdge.getTag("highway")) && filteredSecondLevelEdge.getIdentifier() != originalEdge.getIdentifier() && EDGE_DIRECTION_COMPARATOR.isOppositeDirection((Edge)filteredSecondLevelEdge, originalEdge, false));
    }
}

