/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class OceanBleedingCheck
extends BaseCheck<Long> {
    private static final String DEFAULT_VALID_OCEAN_TAGS = "natural->strait,channel,fjord,sound,bay|harbour->*&harbour->!no|estuary->*&estuary->!no|bay->*&bay->!no|place->sea|seamark:type->harbour,harbour_basin,sea_area|water->bay,cove,harbour|waterway->artificial,dock";
    private final TaggableFilter validOceanTags;
    private static final String DEFAULT_INVALID_OCEAN_TAGS = "man_made->breakwater,pier|natural->beach,marsh,swamp|water->marsh|wetland->bog,fen,mangrove,marsh,saltern,saltmarsh,string_bog,swamp,wet_meadow|landuse->*";
    private final TaggableFilter invalidOceanTags;
    private static final String DEFAULT_OFFENDING_MISCELLANEOUS_LINEITEMS = "railway->rail,narrow_gauge,preserved,subway,disused,monorail,tram,light_rail,funicular,construction,miniature";
    private final TaggableFilter defaultOffendingLineitems;
    private static final String DEFAULT_HIGHWAY_MINIMUM = "TOLL_GANTRY";
    private final HighwayTag highwayMinimum;
    private static final List<String> DEFAULT_HIGHWAYS_EXCLUDE = Collections.emptyList();
    private final List<HighwayTag> highwaysExclude;
    private static final String OCEAN_INSTRUCTION = "Ocean feature {0,number,#} has invalid intersections.";
    private static final String BLEEDING_BUILDING_INSTRUCTION = "Building {0,number,#} intersects the ocean feature.";
    private static final String BLEEDING_LINEITEM_INSTRUCTION = "Way {0,number,#} intersects the ocean feature.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Building {0,number,#} intersects the ocean feature.", "Way {0,number,#} intersects the ocean feature.", "Ocean feature {0,number,#} has invalid intersections.");
    private static final long serialVersionUID = -2229281211747728380L;

    public OceanBleedingCheck(Configuration configuration) {
        super(configuration);
        this.validOceanTags = TaggableFilter.forDefinition(this.configurationValue(configuration, "ocean.valid", DEFAULT_VALID_OCEAN_TAGS));
        this.invalidOceanTags = TaggableFilter.forDefinition(this.configurationValue(configuration, "ocean.invalid", DEFAULT_INVALID_OCEAN_TAGS));
        this.defaultOffendingLineitems = TaggableFilter.forDefinition(this.configurationValue(configuration, "lineItems.offending", DEFAULT_OFFENDING_MISCELLANEOUS_LINEITEMS));
        this.highwayMinimum = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "highway.minimum", DEFAULT_HIGHWAY_MINIMUM).toUpperCase());
        this.highwaysExclude = this.configurationValue(configuration, "highway.exclude", DEFAULT_HIGHWAYS_EXCLUDE).stream().map(element -> Enum.valueOf(HighwayTag.class, element.toUpperCase())).collect(Collectors.toList());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return this.validOceanTags.test(object) && !this.invalidOceanTags.test(object) && (object instanceof Area || object instanceof LineItem);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        boolean oceanIsArea = object instanceof Area;
        Polygon oceanBoundary = oceanIsArea ? ((Area)object).asPolygon() : new Polygon(((LineItem)object).asPolyLine());
        Iterable<LineItem> intersectingRoads = object.getAtlas().lineItemsIntersecting(oceanBoundary, lineItem -> (oceanIsArea || ((LineItem)object).asPolyLine().intersects(lineItem.asPolyLine())) && !BridgeTag.isBridge(lineItem) && (lineItem instanceof Edge && this.validHighwayType().test((Edge)lineItem) || this.defaultOffendingLineitems.test((Taggable)lineItem)));
        Iterable<Area> intersectingBuildings = object.getAtlas().areasIntersecting(oceanBoundary, area -> (oceanIsArea || ((LineItem)object).asPolyLine().intersects(area.asPolygon())) && BuildingTag.isBuilding(area));
        HashSet flaggedObjects = new HashSet();
        StringBuilder instructions = new StringBuilder();
        instructions.append(this.getLocalizedInstruction(2, object.getOsmIdentifier()));
        intersectingBuildings.forEach(building -> {
            flaggedObjects.add(building);
            instructions.append(this.getLocalizedInstruction(0, building.getOsmIdentifier(), object.getOsmIdentifier()));
        });
        intersectingRoads.forEach(road -> {
            flaggedObjects.add(road);
            instructions.append(this.getLocalizedInstruction(1, road.getOsmIdentifier(), object.getOsmIdentifier()));
        });
        return flaggedObjects.isEmpty() ? Optional.empty() : Optional.of(this.createFlag(flaggedObjects, instructions.toString()));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Predicate<Edge> validHighwayType() {
        return edge -> edge.highwayTag().isMoreImportantThanOrEqualTo(this.highwayMinimum) && !this.highwaysExclude.contains((Object)edge.highwayTag());
    }
}

