/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.IntersectionUtilities;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.tags.AerialWayTag;
import org.openstreetmap.atlas.tags.BarrierTag;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.CoveredTag;
import org.openstreetmap.atlas.tags.RailwayTag;
import org.openstreetmap.atlas.tags.ServiceTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class LineCrossingBuildingCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The building with id {0,number,#} has invalid crossings.", "The Line with id {0,number,#} has invalid crossings.");
    private static final long serialVersionUID = 6048659185833217159L;

    private static boolean canCrossBuilding(AtlasItem crossingItem) {
        return crossingItem.getTag("boundary").isPresent() || crossingItem.getTag("landuse").isPresent() || TagPredicates.GOES_UNDERGROUND.test(crossingItem) || TunnelTag.isTunnel(crossingItem) || TagPredicates.IS_POWER_LINE.test(crossingItem) || crossingItem.getTag("addr:interpolation").isPresent() || Validators.isNotOfType((Taggable)crossingItem, BridgeTag.class, (Enum[])new BridgeTag[]{BridgeTag.NO}) || Validators.hasValuesFor(crossingItem, AerialWayTag.class) || Validators.isOfType((Taggable)crossingItem, RailwayTag.class, (Enum[])new RailwayTag[]{RailwayTag.SUBWAY}) || Validators.isOfType((Taggable)crossingItem, ServiceTag.class, (Enum[])new ServiceTag[]{ServiceTag.DRIVEWAY}) || Validators.isOfType((Taggable)crossingItem, CoveredTag.class, (Enum[])new CoveredTag[]{CoveredTag.YES});
    }

    public LineCrossingBuildingCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_AREA.test(object) && Validators.isNotOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.NO}) && !TagPredicates.IS_ROOF.test(object) && !TagPredicates.IS_HIGHWAY_FOR_PEDESTRIANS.test(object) && !Validators.isOfType((Taggable)object, BarrierTag.class, (Enum[])new BarrierTag[]{BarrierTag.TOLL_BOOTH}) && !Validators.isOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.ENTRANCE});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area objectAsArea = (Area)object;
        Polygon areaAsPolygon = objectAsArea.asPolygon();
        Atlas atlas = object.getAtlas();
        List<Edge> edges = this.findCrossingItems(atlas.edgesIntersecting(areaAsPolygon), areaAsPolygon);
        List<Line> lines = this.findCrossingItems(atlas.linesIntersecting(areaAsPolygon), areaAsPolygon);
        if (edges != null || lines != null) {
            CheckFlag flag = new CheckFlag(this.getTaskIdentifier(object));
            flag.addObject(object);
            flag.addInstruction(this.getLocalizedInstruction(0, object.getOsmIdentifier()));
            if (edges != null) {
                edges.forEach(edge -> {
                    flag.addObject((AtlasObject)edge);
                    flag.addInstruction(this.getLocalizedInstruction(1, edge.getOsmIdentifier()));
                });
            }
            if (lines != null) {
                lines.forEach(line -> {
                    flag.addObject((AtlasObject)line);
                    flag.addInstruction(this.getLocalizedInstruction(1, line.getOsmIdentifier()));
                });
            }
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private <T extends LineItem> List<T> findCrossingItems(Iterable<T> collection, Polygon areaAsPolygon) {
        ArrayList<LineItem> list = null;
        for (LineItem item : collection) {
            if (LineCrossingBuildingCheck.canCrossBuilding(item) || IntersectionUtilities.haveExplicitLocationsForIntersections(areaAsPolygon, item)) continue;
            if (list == null) {
                list = new ArrayList<LineItem>();
            }
            list.add(item);
        }
        return list;
    }
}

