/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import com.google.common.collect.Range;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Altitude;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.geojson.GeoJsonGeometry;
import org.openstreetmap.atlas.geography.index.PackedSpatialIndex;
import org.openstreetmap.atlas.geography.index.RTree;
import org.openstreetmap.atlas.geography.index.SpatialIndex;
import org.openstreetmap.atlas.tags.BuildingMinLevelTag;
import org.openstreetmap.atlas.tags.BuildingPartTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HeightTag;
import org.openstreetmap.atlas.tags.MinHeightTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ShadowDetectionCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -6968080042879358551L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The building(s) and/or building part(s) float(s) above the ground. Please check the height/building:levels and min_height/building:min_level tags for all of the buildings parts.", "Relation {0,number,#} is floating.");
    private static final double LEVEL_TO_METERS_CONVERSION = 3.5;
    private static final String ZERO_STRING = "0";
    private static final RelationOrAreaToMultiPolygonConverter MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private final Map<Atlas, SpatialIndex<Relation>> relationSpatialIndices = new HashMap<Atlas, SpatialIndex<Relation>>();

    public ShadowDetectionCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getIdentifier()) && (object instanceof Area || object instanceof Relation && ((Relation)object).isMultiPolygon()) && this.hasMinKey(object) && (this.isBuildingOrPart(object) || this.isBuildingRelationMember(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set<AtlasObject> floatingParts = this.getFloatingParts(object);
        if (!floatingParts.isEmpty()) {
            CheckFlag flag;
            if (object instanceof Relation) {
                flag = this.createFlag(((Relation)object).flatten(), this.getLocalizedInstruction(0, new Object[0]));
                flag.addInstruction(this.getLocalizedInstruction(1, object.getOsmIdentifier()));
            } else {
                flag = this.createFlag(object, this.getLocalizedInstruction(0, new Object[0]));
            }
            for (AtlasObject part : floatingParts) {
                this.markAsFlagged(part.getIdentifier());
                if (part.equals(object)) continue;
                if (part instanceof Relation) {
                    flag.addObjects(((Relation)part).flatten());
                    flag.addInstruction(this.getLocalizedInstruction(1, part.getOsmIdentifier()));
                    continue;
                }
                flag.addObject(part);
            }
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private SpatialIndex<Relation> buildRelationSpatialIndex(final Atlas atlas) {
        PackedSpatialIndex<Relation, Long> index = new PackedSpatialIndex<Relation, Long>(new RTree()){
            private static final long serialVersionUID = -3139831928323333246L;

            @Override
            protected Long compress(Relation item) {
                return item.getIdentifier();
            }

            @Override
            protected boolean isValid(Relation item, Rectangle bounds) {
                return item.intersects(bounds);
            }

            @Override
            protected Relation restore(Long packed) {
                return atlas.relation(packed);
            }
        };
        atlas.relations(relation -> relation.isMultiPolygon() && BuildingTag.isBuilding(relation)).forEach(index::add);
        return index;
    }

    private Set<AtlasObject> getFloatingParts(AtlasObject startingPart) {
        HashSet<AtlasObject> connectedParts = new HashSet<AtlasObject>();
        ArrayDeque<AtlasObject> toCheck = new ArrayDeque<AtlasObject>();
        connectedParts.add(startingPart);
        toCheck.add(startingPart);
        while (!toCheck.isEmpty()) {
            AtlasObject checking = (AtlasObject)toCheck.poll();
            if (!this.isOffGround(checking)) {
                return new HashSet<AtlasObject>();
            }
            HashSet<AtlasEntity> neighboringParts = new HashSet<AtlasEntity>();
            Rectangle checkingBounds = checking.bounds();
            neighboringParts.addAll(Iterables.asSet(checking.getAtlas().areasIntersecting(checkingBounds, area -> this.neighboringPart((AtlasObject)area, checking, (Set<AtlasObject>)connectedParts))));
            if (!this.relationSpatialIndices.containsKey(checking.getAtlas())) {
                this.relationSpatialIndices.put(checking.getAtlas(), this.buildRelationSpatialIndex(checking.getAtlas()));
            }
            neighboringParts.addAll(Iterables.asSet(this.relationSpatialIndices.get(checking.getAtlas()).get(checkingBounds, relation -> this.neighboringPart((AtlasObject)relation, checking, (Set<AtlasObject>)connectedParts))));
            connectedParts.addAll(neighboringParts);
            toCheck.addAll(neighboringParts);
        }
        return connectedParts;
    }

    private boolean hasMinKey(AtlasObject object) {
        return Validators.hasValuesFor(object, BuildingMinLevelTag.class) || Validators.hasValuesFor(object, MinHeightTag.class);
    }

    private boolean isBuildingOrPart(AtlasObject object) {
        return BuildingTag.isBuilding(object) && Validators.isNotOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.ROOF}) || Validators.isNotOfType((Taggable)object, BuildingPartTag.class, (Enum[])new BuildingPartTag[]{BuildingPartTag.NO});
    }

    private boolean isBuildingRelationMember(AtlasObject object) {
        return object instanceof AtlasEntity && ((AtlasEntity)object).relations().stream().anyMatch(relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.BUILDING}) && relation.members().stream().anyMatch(member -> member.getEntity().equals(object) && member.getRole().equals("outline") || member.getRole().equals("part")));
    }

    private boolean isOffGround(AtlasObject object) {
        double minLevel;
        double minHeight;
        try {
            minHeight = Double.parseDouble(object.getOsmTags().getOrDefault("min_height", ZERO_STRING));
            minLevel = Double.parseDouble(object.getOsmTags().getOrDefault("building:min_level", ZERO_STRING));
        }
        catch (NumberFormatException badTagValue) {
            return true;
        }
        return minHeight > 0.0 || minLevel > 0.0;
    }

    private boolean neighboringPart(AtlasObject object, AtlasObject part, Set<AtlasObject> checked) {
        try {
            GeoJsonGeometry objectPolygon;
            GeoJsonGeometry partPolygon = part instanceof Area ? ((Area)part).asPolygon() : MULTI_POLYGON_CONVERTER.convert((Relation)part);
            GeoJsonGeometry geoJsonGeometry = objectPolygon = object instanceof Area ? ((Area)object).asPolygon() : MULTI_POLYGON_CONVERTER.convert((Relation)object);
            return !checked.contains(object) && !this.isFlagged(object.getIdentifier()) && (this.isBuildingOrPart(object) || this.isBuildingRelationMember(object)) && (partPolygon instanceof Polygon ? objectPolygon.overlaps((PolyLine)partPolygon) : objectPolygon.overlaps((MultiPolygon)partPolygon)) && this.neighborsHeightContains(part, object);
        }
        catch (CoreException invalidMultiPolygon) {
            return false;
        }
    }

    private boolean neighborsHeightContains(AtlasObject part, AtlasObject neighbor) {
        Map<String, String> neighborTags = neighbor.getOsmTags();
        Map<String, String> partTags = part.getOsmTags();
        try {
            double partMinHeight = MinHeightTag.get(part).map(Altitude::asMeters).orElseGet(() -> partTags.containsKey("building:min_level") ? Double.parseDouble((String)partTags.get("building:min_level")) * 3.5 : 0.0);
            double partMaxHeight = HeightTag.get(part).map(Altitude::asMeters).orElseGet(() -> partTags.containsKey("building:levels") ? Double.parseDouble((String)partTags.get("building:levels")) * 3.5 : partMinHeight);
            double neighborMinHeight = MinHeightTag.get(neighbor).map(Altitude::asMeters).orElseGet(() -> neighborTags.containsKey("building:min_level") ? Double.parseDouble((String)neighborTags.get("building:min_level")) * 3.5 : 0.0);
            double neighborMaxHeight = HeightTag.get(neighbor).map(Altitude::asMeters).orElseGet(() -> neighborTags.containsKey("building:levels") ? Double.parseDouble((String)neighborTags.get("building:levels")) * 3.5 : 0.0);
            return Range.closed(partMinHeight, partMaxHeight).isConnected(Range.closed(neighborMinHeight, neighborMaxHeight));
        }
        catch (IllegalArgumentException exc) {
            return false;
        }
    }
}

