/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteCommand;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.checks.maproulette.serializer.ChallengeDeserializer;
import org.openstreetmap.atlas.checks.maproulette.serializer.TaskDeserializer;
import org.openstreetmap.atlas.checks.utility.FileUtility;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteUploadCommand
extends MapRouletteCommand {
    private static final Command.Switch<File> INPUT_DIRECTORY = new Command.Switch("logfiles", "Path to folder containing log files to upload to MapRoulette.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> CONFIG_LOCATION = new Command.Switch("config", "Path to a file containing MapRoulette challenge configuration.", File::new, Command.Optionality.OPTIONAL, "config/configuration.json");
    private static final Command.Switch<List<String>> COUNTRIES = new Command.Switch("countries", "A comma separated list of ISO3 country codes to filter flags by.", string -> Arrays.asList(string.split(",")), Command.Optionality.OPTIONAL);
    private static final Command.Switch<List<String>> CHECKS = new Command.Switch("checks", "A comma separated list of check names to filter flags by.", string -> Arrays.asList(string.split(",")), Command.Optionality.OPTIONAL);
    private static final String PARAMETER_CHALLENGE = "challenge";
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteUploadCommand.class);
    private final Map<String, Challenge> checkNameChallengeMap = new HashMap<String, Challenge>();

    public static void main(String[] args) {
        new MapRouletteUploadCommand().run(args);
    }

    public String getCountryDisplayName(Optional<String> countryCode) {
        return countryCode.isPresent() ? Arrays.stream(countryCode.get().split(",")).map(country -> IsoCountry.displayCountry(country).orElse((String)country)).collect(Collectors.joining(", ")) : "";
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(INPUT_DIRECTORY, OUTPUT_PATH, CONFIG_LOCATION, COUNTRIES, CHECKS);
    }

    @Override
    protected void execute(CommandMap commandMap, MapRouletteConfiguration configuration) {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Task.class), new TaskDeserializer(configuration.getProjectName())).create();
        Configuration instructions = this.loadConfiguration(commandMap);
        Optional<?> countries = commandMap.getOption(COUNTRIES);
        Optional<?> checks = commandMap.getOption(CHECKS);
        ((File)commandMap.get(INPUT_DIRECTORY)).listFilesRecursively().forEach(logFile -> {
            Optional<FileUtility.LogOutputFileType> optionalHandledFileType = FileUtility.getOptionalLogOutputType(logFile);
            optionalHandledFileType.ifPresent(logOutputFileType -> {
                try (BufferedReader reader = FileUtility.getReader(logFile, logOutputFileType);){
                    reader.lines().forEach(line -> {
                        Task task = gson.fromJson((String)line, Task.class);
                        Optional countryCode = Iterables.stream(task.getGeoJson().orElse(new JsonArray())).map(this::getElementCountryCode).firstMatching(Optional::isPresent).get();
                        String check = task.getChallengeName();
                        if ((!countries.isPresent() || countryCode.isPresent() && ((List)countries.get()).contains(countryCode.get())) && (!checks.isPresent() || ((List)checks.get()).contains(check))) {
                            try {
                                Challenge challenge = this.getChallenge(task.getChallengeName(), instructions, countryCode);
                                this.addTask(challenge, task);
                            }
                            catch (UnsupportedEncodingException | URISyntaxException error) {
                                logger.error("Exception thrown while adding task: ", (Throwable)error);
                            }
                        }
                    });
                    this.uploadTasks();
                }
                catch (IOException error) {
                    logger.error("Exception while reading {}:", logFile, (Object)error);
                }
            });
        });
    }

    private Challenge getChallenge(String checkName, Configuration fallbackConfiguration, Optional<String> countryCode) {
        return this.checkNameChallengeMap.computeIfAbsent(checkName, name -> {
            Map challengeMap = (Map)fallbackConfiguration.get(this.getChallengeParameter(checkName), Collections.emptyMap()).value();
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Challenge.class), new ChallengeDeserializer()).create();
            Challenge result = gson.fromJson(gson.toJson(challengeMap), Challenge.class);
            String challengeName = String.join((CharSequence)" - ", this.getCountryDisplayName(countryCode), result.getName().isEmpty() ? checkName : result.getName());
            result.setName(challengeName);
            return result;
        });
    }

    private String getChallengeParameter(String checkName) {
        return MessageFormat.format("{0}.{1}", checkName, PARAMETER_CHALLENGE);
    }

    private Optional<String> getElementCountryCode(JsonElement element) {
        JsonObject properties;
        JsonObject elementJson = element.getAsJsonObject();
        if (elementJson.has("properties") && (properties = elementJson.get("properties").getAsJsonObject()).has("iso_country_code")) {
            return Optional.of(properties.get("iso_country_code").getAsString());
        }
        return Optional.empty();
    }

    private Configuration loadConfiguration(CommandMap map) {
        return new StandardConfiguration((File)map.get(CONFIG_LOCATION));
    }
}

