/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.event.Event;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.tags.HighwayTag;

public final class CheckFlagEvent
extends Event {
    private static final GeoJsonBuilder GEOJSON_BUILDER = new GeoJsonBuilder();
    private static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String GEOMETRIES = "geometries";
    private static final String FEATURES = "features";
    private static final String FEATURE_COLLECTION = "FeatureCollection";
    private static final String INSTRUCTIONS = "instructions";
    private static final String IDENTIFIERS = "identifiers";
    private static final Gson GSON = new Gson();
    private final String checkName;
    private final CheckFlag flag;

    public static JsonObject flagToFeature(CheckFlag flag, Map<String, String> additionalProperties) {
        JsonArray geometriesJsonArray;
        JsonObject feature;
        JsonObject flagProperties = new JsonObject();
        flagProperties.addProperty(INSTRUCTIONS, flag.getInstructions());
        additionalProperties.forEach(flagProperties::addProperty);
        List<GeoJsonBuilder.GeometryWithProperties> geometriesWithProperties = flag.getGeometryWithProperties();
        Set<FlaggedObject> flaggedRelations = flag.getFlaggedRelations();
        JsonArray featureProperties = new JsonArray();
        HashSet<JsonElement> featureOsmIds = new HashSet<JsonElement>();
        if (!geometriesWithProperties.isEmpty()) {
            feature = geometriesWithProperties.size() + flaggedRelations.size() == 1 ? GEOJSON_BUILDER.create(geometriesWithProperties.get(0)) : GEOJSON_BUILDER.createGeometryCollectionFeature(geometriesWithProperties).jsonObject();
            geometriesJsonArray = feature.get("geometry").getAsJsonObject().getAsJsonArray(GEOMETRIES);
            geometriesWithProperties.forEach(geometry -> Optional.ofNullable(geometry.getProperties()).ifPresent(propertyMap -> {
                JsonObject properties = new JsonObject();
                propertyMap.forEach((key, value) -> properties.addProperty((String)key, (String)value));
                featureProperties.add(properties);
                Optional.ofNullable(properties.get("osmIdentifier")).ifPresent(featureOsmIds::add);
            }));
        } else {
            feature = new JsonObject();
            geometriesJsonArray = new JsonArray();
        }
        if (!flaggedRelations.isEmpty()) {
            if (!feature.has("type")) {
                feature.addProperty("type", "Feature");
            }
            List<JsonObject> flaggedRelationFeatures = CheckFlagEvent.getFlaggedRelationsGeojsonFeatures(flag);
            if (flaggedRelations.size() == 1 && !feature.has("geometry")) {
                feature.add("geometry", flaggedRelationFeatures.get(0).get("geometry"));
            } else if (flaggedRelations.size() != 1 && !feature.has("geometry")) {
                JsonObject geometryCollection = new JsonObject();
                geometryCollection.add(GEOMETRIES, geometriesJsonArray);
                geometryCollection.addProperty("type", GEOMETRY_COLLECTION);
                feature.add("geometry", geometryCollection);
            }
            geometriesJsonArray.addAll(CheckFlagEvent.populateFlaggedRelationGeometries(flaggedRelationFeatures));
            featureProperties.addAll(CheckFlagEvent.populateFlaggedRelationFeatureProperties(flaggedRelationFeatures));
            featureOsmIds.addAll(CheckFlagEvent.populateFlaggedRelationFeatureOsmIds(flaggedRelationFeatures));
        }
        JsonArray uniqueFeatureOsmIds = new JsonArray();
        featureOsmIds.forEach(uniqueFeatureOsmIds::add);
        CheckFlagEvent.featureDecorator(featureProperties).ifPresent(decorator -> flagProperties.addProperty("name", String.format("%s (%s)", Optional.ofNullable(flagProperties.getAsJsonPrimitive("name")).map(JsonPrimitive::getAsString).orElse("Task"), decorator)));
        flagProperties.add("feature_properties", featureProperties);
        flagProperties.add("feature_osmids", uniqueFeatureOsmIds);
        flagProperties.addProperty("feature_count", featureProperties.size());
        flagProperties.add(IDENTIFIERS, GSON.toJsonTree(flag.getUniqueIdentifiers()));
        feature.addProperty("id", flag.getIdentifier());
        feature.add("properties", flagProperties);
        return feature;
    }

    public static JsonObject flagToJson(CheckFlag flag, Map<String, String> additionalProperties) {
        Set<FlaggedObject> flaggedRelations;
        JsonObject flagJson = new JsonObject();
        if (!flag.getFlaggedObjects().isEmpty()) {
            flagJson = GEOJSON_BUILDER.createFromGeometriesWithProperties(flag.getGeometryWithProperties()).jsonObject();
        }
        if (!(flaggedRelations = flag.getFlaggedRelations()).isEmpty()) {
            if (!flagJson.has(FEATURES)) {
                flagJson.addProperty("type", FEATURE_COLLECTION);
                flagJson.add(FEATURES, new JsonArray());
            }
            JsonArray features = flagJson.getAsJsonArray(FEATURES);
            flaggedRelations.stream().map(flaggedRelation -> flaggedRelation.asGeoJsonFeature(flag.getIdentifier())).forEach(features::add);
        }
        JsonObject flagPropertiesJson = new JsonObject();
        flagPropertiesJson.addProperty("id", flag.getIdentifier());
        flagPropertiesJson.addProperty(INSTRUCTIONS, flag.getInstructions());
        flagPropertiesJson.add(IDENTIFIERS, GSON.toJsonTree(flag.getUniqueIdentifiers()));
        additionalProperties.forEach(flagPropertiesJson::addProperty);
        flagJson.add("properties", flagPropertiesJson);
        return flagJson;
    }

    private static Optional<String> featureDecorator(JsonArray featureProperties) {
        HighwayTag highestHighwayTag = null;
        for (JsonElement featureProperty : featureProperties) {
            HighwayTag baslineHighwayTag = highestHighwayTag == null ? HighwayTag.NO : highestHighwayTag;
            try {
                highestHighwayTag = Optional.ofNullable(((JsonObject)featureProperty).getAsJsonPrimitive("highway")).map(JsonPrimitive::getAsString).map(String::toUpperCase).map(HighwayTag::valueOf).filter(baslineHighwayTag::isLessImportantThan).orElse(highestHighwayTag);
            }
            catch (IllegalArgumentException badValue) {
                return Optional.empty();
            }
        }
        return Optional.ofNullable(highestHighwayTag).map(tag -> String.format("%s=%s", "highway", tag.getTagValue()));
    }

    private static JsonElement getFlaggedRelationGeometryFromFeature(JsonObject flaggedRelationFeature) {
        return flaggedRelationFeature.get("geometry");
    }

    private static JsonElement getFlaggedRelationPropertyFromFeature(JsonObject flaggedRelationFeature) {
        return flaggedRelationFeature.get("properties");
    }

    private static List<JsonObject> getFlaggedRelationsGeojsonFeatures(CheckFlag flag) {
        return flag.getFlaggedRelations().stream().map(flaggedRelation -> flaggedRelation.asGeoJsonFeature(flag.getIdentifier())).collect(Collectors.toList());
    }

    private static Set<JsonElement> populateFlaggedRelationFeatureOsmIds(List<JsonObject> flaggedRelationFeatures) {
        return flaggedRelationFeatures.stream().map(CheckFlagEvent::getFlaggedRelationPropertyFromFeature).map(jsonElement -> jsonElement.getAsJsonObject().get("osmIdentifier")).collect(Collectors.toSet());
    }

    private static JsonArray populateFlaggedRelationFeatureProperties(List<JsonObject> flaggedRelationFeatures) {
        JsonArray featureProperties = new JsonArray();
        flaggedRelationFeatures.stream().map(CheckFlagEvent::getFlaggedRelationPropertyFromFeature).forEach(featureProperties::add);
        return featureProperties;
    }

    private static JsonArray populateFlaggedRelationGeometries(List<JsonObject> flaggedRelationFeatures) {
        JsonArray geometriesOfFlaggedRelations = new JsonArray();
        flaggedRelationFeatures.stream().map(CheckFlagEvent::getFlaggedRelationGeometryFromFeature).forEach(geometriesOfFlaggedRelations::add);
        return geometriesOfFlaggedRelations;
    }

    public CheckFlagEvent(String checkName, CheckFlag flag) {
        this.checkName = checkName;
        this.flag = flag;
    }

    public String asLineDelimitedGeoJsonFeatures() {
        return this.asLineDelimitedGeoJsonFeatures(jsonObject -> {});
    }

    public String asLineDelimitedGeoJsonFeatures(Consumer<JsonObject> jsonMutator) {
        JsonObject flagGeoJsonFeature = this.flag.asGeoJsonFeature();
        JsonObject flagGeoJsonProperties = flagGeoJsonFeature.get("properties").getAsJsonObject();
        flagGeoJsonProperties.addProperty("flag:check", this.getCheckName());
        flagGeoJsonProperties.addProperty("flag:timestamp", this.getTimestamp().toString());
        jsonMutator.accept(flagGeoJsonFeature);
        StringBuilder builder = new StringBuilder().append(flagGeoJsonFeature.toString());
        FlaggedObject[] flaggedObjects = this.flag.getFlaggedObjects().toArray(new FlaggedObject[0]);
        int flaggedObjectsSize = flaggedObjects.length;
        if (flaggedObjectsSize > 0) {
            JsonObject feature;
            int index;
            builder.append('\n');
            for (index = 0; index < flaggedObjectsSize - 1; ++index) {
                feature = flaggedObjects[index].asGeoJsonFeature(this.flag.getIdentifier());
                jsonMutator.accept(feature);
                builder.append(feature.toString()).append('\n');
            }
            feature = flaggedObjects[index].asGeoJsonFeature(this.flag.getIdentifier());
            jsonMutator.accept(feature);
            builder.append(feature.toString());
        }
        return builder.toString();
    }

    public CheckFlag getCheckFlag() {
        return this.flag;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public JsonObject toGeoJsonFeature() {
        HashMap<String, String> contextualProperties = new HashMap<String, String>();
        contextualProperties.put("name", this.getCheckFlag().getChallengeName().orElse(this.getCheckName()));
        contextualProperties.put("generator", "AtlasChecks");
        contextualProperties.put("timestamp", this.getTimestamp().toString());
        return CheckFlagEvent.flagToFeature(this.getCheckFlag(), contextualProperties);
    }

    public JsonObject toGeoJsonFeatureCollection() {
        HashMap<String, String> contextualProperties = new HashMap<String, String>();
        contextualProperties.put("generator", this.getCheckName());
        contextualProperties.put("timestamp", this.getTimestamp().toString());
        return CheckFlagEvent.flagToJson(this.getCheckFlag(), contextualProperties);
    }

    public String toString() {
        return this.toGeoJsonFeatureCollection().toString();
    }
}

