/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import java.util.Optional;
import org.openstreetmap.atlas.checks.base.Check;
import org.openstreetmap.atlas.checks.distributed.RunnableCheckBase;
import org.openstreetmap.atlas.checks.event.CheckFlagEvent;
import org.openstreetmap.atlas.checks.event.MetricEvent;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteClient;
import org.openstreetmap.atlas.event.EventService;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunnableCheck
extends RunnableCheckBase<Check>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RunnableCheck.class);

    public RunnableCheck(String country, Check check, Iterable<AtlasObject> objects, MapRouletteClient client) {
        super(country, check, objects, client);
    }

    public RunnableCheck(String country, Check check, Iterable<AtlasObject> objects, EventService eventService) {
        super(country, check, objects, null, eventService);
    }

    @Override
    public void run() {
        try {
            Time timer = Time.now();
            this.getObjects().forEach(object -> {
                Optional<CheckFlag> flag = this.getCheck().check((AtlasObject)object);
                if (flag.isPresent()) {
                    this.addTask(flag.get());
                    this.getEventService().post(new CheckFlagEvent(this.getName(), flag.get()));
                }
            });
            this.getCheck().clear();
            Duration checkRunTime = timer.elapsedSince();
            logger.info("{} completed in {}.", (Object)this.getName(), (Object)checkRunTime);
            this.getEventService().post(new MetricEvent(this.getName(), checkRunTime));
            this.uploadTasks();
        }
        catch (Exception e) {
            logger.error(String.format("%s failed to complete.", this.getName()), (Throwable)e);
        }
    }
}

