/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.atlas.CountrySpecificAtlasFilePathFilter;
import org.openstreetmap.atlas.checks.base.Check;
import org.openstreetmap.atlas.checks.distributed.AtlasDataSource;
import org.openstreetmap.atlas.checks.distributed.AtlasFilePathResolver;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntegrityChecksCommandArguments
extends SparkJob {
    @Deprecated(since="6.0.2")
    protected static final Command.Switch<String> ATLAS_FOLDER = new Command.Switch<String>("inputFolder", "Path of folder which contains Atlas file(s)", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    protected static final String OUTPUT_ATLAS_FOLDER = "atlas";
    protected static final String OUTPUT_FLAG_FOLDER = "flag";
    protected static final String OUTPUT_GEOJSON_FOLDER = "geojson";
    protected static final String OUTPUT_METRIC_FOLDER = "metric";
    protected static final String OUTPUT_TIPPECANOE_FOLDER = "tippecanoe";
    static final Command.Switch<List<String>> CHECK_FILTER = new Command.Switch("checkFilter", "Comma-separated list of checks to run", checks -> Arrays.asList(checks.split(",")), Command.Optionality.OPTIONAL);
    static final Command.Switch<StringList> CONFIGURATION_FILES = new Command.Switch("configFiles", "Comma-separated list of configuration datasources.", value -> StringList.split(value, ","), Command.Optionality.OPTIONAL);
    static final Command.Switch<String> CONFIGURATION_JSON = new Command.Switch<String>("configJson", "Json formatted configuration.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    static final Command.Switch<String> COUNTRIES = new Command.Switch<String>("countries", "Comma-separated list of country ISO3 codes to be processed", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    static final Command.Switch<MapRouletteConfiguration> MAP_ROULETTE = new Command.Switch("maproulette", "Map roulette server information, format <Host>:<Port>:<ProjectName>:<ApiKey>, projectName is optional.", MapRouletteConfiguration::parse, Command.Optionality.OPTIONAL);
    static final Command.Switch<Set<OutputFormats>> OUTPUT_FORMATS = new Command.Switch("outputFormats", "Comma-separated list of output formats (flags, metrics, geojson, tippecanoe).", csvFormats -> Stream.of(csvFormats.split(",")).map(format -> Enum.valueOf(OutputFormats.class, format.toUpperCase())).collect(Collectors.toSet()), Command.Optionality.OPTIONAL, "flags,metrics");
    static final Command.Switch<Rectangle> PBF_BOUNDING_BOX = new Command.Switch("pbfBoundingBox", "OSM protobuf data will be loaded only in this bounding box", Rectangle::forString, Command.Optionality.OPTIONAL);
    static final Command.Switch<Boolean> PBF_SAVE_INTERMEDIATE_ATLAS = new Command.Switch("savePbfAtlas", "Saves intermediate atlas files created when processing OSM protobuf data.", Boolean::valueOf, Command.Optionality.OPTIONAL, "false");
    private static final String ATLAS_FILENAME_PATTERN_FORMAT = "^%s_([0-9]+)-([0-9]+)-([0-9]+)";
    private static final Logger logger = LoggerFactory.getLogger(IntegrityChecksCommandArguments.class);
    private static final long serialVersionUID = 3411367641498888770L;

    public static MultiMap<String, Shard> countryShardMapFromShardFiles(Set<String> countries, AtlasFilePathResolver pathResolver, String atlasFolder, Map<String, String> sparkContext) {
        MultiMap<String, Shard> countryShardMap = new MultiMap<String, Shard>();
        logger.info("Building country shard map from country shard files.");
        countries.forEach(country -> {
            String countryDirectory = pathResolver.resolvePath(atlasFolder, (String)country);
            CountrySpecificAtlasFilePathFilter atlasFilter = new CountrySpecificAtlasFilePathFilter((String)country);
            Pattern atlasFilePattern = Pattern.compile(String.format(ATLAS_FILENAME_PATTERN_FORMAT, country));
            FileSystemHelper.listResourcesRecursively(countryDirectory, sparkContext, atlasFilter).forEach(shardFile -> {
                String shardFileName = shardFile.getName();
                Matcher matcher = atlasFilePattern.matcher(shardFileName);
                if (matcher.find()) {
                    try {
                        String zoomString = matcher.group(1);
                        String xString = matcher.group(2);
                        String yString = matcher.group(3);
                        countryShardMap.add((String)country, new SlippyTile(Integer.parseInt(xString), Integer.parseInt(yString), Integer.parseInt(zoomString)));
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Couldn't parse shard file name %s.", shardFileName), (Throwable)e);
                    }
                } else {
                    logger.warn(String.format("Skipping atlas file %s, its name does not conform to the sharded standard.", shardFileName));
                }
            });
        });
        return countryShardMap;
    }

    protected static Iterable<AtlasObject> objectsToCheck(Atlas atlas, Check check) {
        return IntegrityChecksCommandArguments.objectsToCheck(atlas, check, atlasEntity -> true);
    }

    protected static Iterable<AtlasObject> objectsToCheck(Atlas atlas, Check check, Predicate<AtlasEntity> geoFilter) {
        return new MultiIterable<AtlasObject>(Iterables.filter(atlas.entities(), geoFilter), check.finder().map(finder -> finder.find(atlas)).orElse(Collections.emptyList()));
    }

    protected AtlasDataSource getAtlasDataSource(Map<String, String> sparkContext, Configuration checksConfiguration, Rectangle pbfBoundary) {
        return new AtlasDataSource(sparkContext, checksConfiguration, pbfBoundary);
    }

    @Override
    protected Command.SwitchList switches() {
        return super.switches().with(ATLAS_FOLDER, MAP_ROULETTE, COUNTRIES, CONFIGURATION_FILES, CONFIGURATION_JSON, PBF_BOUNDING_BOX, PBF_SAVE_INTERMEDIATE_ATLAS, OUTPUT_FORMATS, CHECK_FILTER);
    }

    protected static enum OutputFormats {
        FLAGS,
        GEOJSON,
        METRICS,
        TIPPECANOE;

    }
}

