/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.atlas.checks.commands.JSONFlagDiffSubCommand;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasChecksLogDiffSubCommand
extends JSONFlagDiffSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasChecksLogDiffSubCommand.class);

    public AtlasChecksLogDiffSubCommand() {
        super("log-diff", "Takes 2 sets of atlas-checks log flag files and reports the number of additions, subtractions, and changed flags from reference to input.", "log");
    }

    @Override
    protected Map<String, Map<Set<String>, JsonObject>> mapFeatures(File file) {
        HashMap<String, Map<Set<String>, JsonObject>> checkFeatureMap = new HashMap<String, Map<Set<String>, JsonObject>>();
        try (InputStreamReader inputStreamReader = file.isGzipped() ? new InputStreamReader(new GZIPInputStream(new FileInputStream(file.getFile()))) : new FileReader(file.getPath());
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                JsonObject source = this.getGson().fromJson(line, JsonObject.class);
                String checkName = source.get("properties").getAsJsonObject().get("generator").getAsString();
                checkFeatureMap.putIfAbsent(checkName, new HashMap());
                if (((Map)checkFeatureMap.get(checkName)).containsKey(this.getIdentifiers(source))) {
                    logger.info("Duplicate flag found in {}: {}", (Object)file.getAbsolutePath(), (Object)source);
                }
                ((Map)checkFeatureMap.get(checkName)).put(this.getIdentifiers(source), source);
            }
        }
        catch (IOException exception) {
            logger.warn("File read failed with exception", (Throwable)exception);
        }
        return checkFeatureMap;
    }

    private Set<String> getIdentifiers(JsonObject flagJson) {
        JsonObject flagProperties = flagJson.get("properties").getAsJsonObject();
        return flagProperties.has("identifiers") ? Iterables.stream(flagProperties.get("identifiers").getAsJsonArray()).map(JsonElement::getAsString).collectToSet() : Iterables.stream(flagJson.get("features").getAsJsonArray()).filter(object -> object.getAsJsonObject().get("properties").getAsJsonObject().has("identifier") || object.getAsJsonObject().get("properties").getAsJsonObject().has("ItemId")).map(object -> Optional.ofNullable(object.getAsJsonObject().get("properties").getAsJsonObject().get("identifier")).orElse(object.getAsJsonObject().get("properties").getAsJsonObject().get("ItemId")).getAsString()).collectToSet();
    }
}

