/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab.edgeray;

import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jtslab.edgeray.EdgeRay;

public class EdgeRayIntersectionArea {
    private Geometry geomA;
    private Geometry geomB;
    double area = 0.0;

    public static double area(Geometry geom0, Geometry geom1) {
        EdgeRayIntersectionArea area = new EdgeRayIntersectionArea(geom0, geom1);
        return area.getArea();
    }

    public EdgeRayIntersectionArea(Geometry geom0, Geometry geom1) {
        this.geomA = geom0;
        this.geomB = geom1;
    }

    public double getArea() {
        this.addIntersections();
        this.addResultVertices(this.geomA, this.geomB);
        this.addResultVertices(this.geomB, this.geomA);
        return this.area;
    }

    private void addIntersections() {
        CoordinateSequence seqA = this.getVertices(this.geomA);
        boolean[] isIntersected0 = new boolean[seqA.size() - 1];
        CoordinateSequence seqB = this.getVertices(this.geomB);
        boolean[] isIntersected1 = new boolean[seqB.size() - 1];
        boolean isCCWA = Orientation.isCCW(seqA);
        boolean isCCWB = Orientation.isCCW(seqB);
        RobustLineIntersector li = new RobustLineIntersector();
        for (int i = 0; i < seqA.size() - 1; ++i) {
            Coordinate a0 = seqA.getCoordinate(i);
            Coordinate a1 = seqA.getCoordinate(i + 1);
            if (isCCWA) {
                Coordinate temp = a0;
                a0 = a1;
                a1 = temp;
            }
            for (int j = 0; j < seqB.size() - 1; ++j) {
                boolean isAenteringB;
                Coordinate b0 = seqB.getCoordinate(j);
                Coordinate b1 = seqB.getCoordinate(j + 1);
                if (isCCWB) {
                    Coordinate temp = b0;
                    b0 = b1;
                    b1 = temp;
                }
                li.computeIntersection(a0, a1, b0, b1);
                if (!li.hasIntersection()) continue;
                isIntersected0[i] = true;
                isIntersected1[j] = true;
                Coordinate intPt = li.getIntersection(0);
                boolean bl = isAenteringB = 1 == Orientation.index(a0, a1, b1);
                if (isAenteringB) {
                    this.area += EdgeRay.areaTerm(intPt, a0, a1, true);
                    this.area += EdgeRay.areaTerm(intPt, b1, b0, false);
                    continue;
                }
                this.area += EdgeRay.areaTerm(intPt, a1, a0, false);
                this.area += EdgeRay.areaTerm(intPt, b0, b1, true);
            }
        }
    }

    private void addResultVertices(Geometry geom0, Geometry geom1) {
        IndexedPointInAreaLocator locator = new IndexedPointInAreaLocator(geom1);
        CoordinateSequence seq = this.getVertices(geom0);
        boolean isCW = !Orientation.isCCW(seq);
        for (int i = 0; i < seq.size() - 1; ++i) {
            Coordinate vPrev = i == 0 ? seq.getCoordinate(seq.size() - 2) : seq.getCoordinate(i - 1);
            Coordinate v = seq.getCoordinate(i);
            Coordinate vNext = seq.getCoordinate(i + 1);
            if (0 != locator.locate(v)) continue;
            this.area += EdgeRay.areaTerm(v, vPrev, !isCW);
            this.area += EdgeRay.areaTerm(v, vNext, isCW);
        }
    }

    private CoordinateSequence getVertices(Geometry geom) {
        Polygon poly = (Polygon)geom;
        CoordinateSequence seq = poly.getExteriorRing().getCoordinateSequence();
        return seq;
    }
}

