/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jtslab;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jtslab.snapround.GeometrySnapRounder;

public class SnapRoundFunctions {
    public static Geometry snapRoundLines(Geometry geom, double scaleFactor) {
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        GeometrySnapRounder gsr = new GeometrySnapRounder(pm);
        gsr.setLineworkOnly(true);
        Geometry snapped = gsr.execute(geom);
        return snapped;
    }

    public static Geometry snapRound(Geometry geomA, Geometry geomB, double scaleFactor) {
        PrecisionModel pm = new PrecisionModel(scaleFactor);
        Geometry geom = geomA;
        if (geomB != null) {
            geom = geomA.getFactory().createGeometryCollection(new Geometry[]{geomA, geomB});
        }
        GeometrySnapRounder gsr = new GeometrySnapRounder(pm);
        Geometry snapped = gsr.execute(geom);
        return snapped;
    }
}

