/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class VariableWidthBuffer {
    private LineString line;
    private double[] width;
    private GeometryFactory geomFactory;

    public static Geometry buffer(Geometry line, double startWidth, double endWidth) {
        double[] width = VariableWidthBuffer.interpolate((LineString)line, startWidth, endWidth);
        VariableWidthBuffer vb = new VariableWidthBuffer(line, width);
        return vb.getResult();
    }

    public static Geometry bufferAternating(Geometry line, double width1, double width2) {
        int nPts = line.getNumPoints();
        double[] width = new double[nPts];
        for (int i = 0; i < width.length; ++i) {
            width[i] = i % 2 == 0 ? width1 : width2;
        }
        VariableWidthBuffer vb = new VariableWidthBuffer(line, width);
        return vb.getResult();
    }

    public static double[] interpolate(LineString line, double start, double end) {
        start = Math.abs(start);
        end = Math.abs(end);
        double[] widths = new double[line.getNumPoints()];
        widths[0] = start;
        widths[widths.length - 1] = end;
        double totalLen = line.getLength();
        Coordinate[] pts = line.getCoordinates();
        double currLen = 0.0;
        for (int i = 1; i < widths.length; ++i) {
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / totalLen;
            double delta = lenFrac * (end - start);
            widths[i] = start + delta;
        }
        return widths;
    }

    private static double[] abs(double[] v) {
        double[] a = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            a[i] = Math.abs(v[i]);
        }
        return a;
    }

    public VariableWidthBuffer(Geometry line, double[] width) {
        this.line = (LineString)line;
        this.width = VariableWidthBuffer.abs(width);
        this.geomFactory = line.getFactory();
    }

    public Geometry getResult() {
        ArrayList<Geometry> parts = new ArrayList<Geometry>();
        Coordinate[] pts = this.line.getCoordinates();
        for (int i = 0; i < this.line.getNumPoints(); ++i) {
            double dist = this.width[i] / 2.0;
            if (dist > 0.0) {
                Geometry ptBuf = this.line.getPointN(i).buffer(dist);
                parts.add(ptBuf);
            }
            if (i == 0) continue;
            double width0 = this.width[i - 1];
            double width1 = this.width[i];
            if (!(width0 > 0.0) && !(width1 > 0.0)) continue;
            Coordinate[] curvePts = this.generateSegmentCurve(pts[i - 1], pts[i], width0, width1);
            Polygon segBuf = this.geomFactory.createPolygon(curvePts);
            parts.add(segBuf);
        }
        GeometryCollection partsGeom = this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray(parts));
        Geometry buffer = partsGeom.union();
        return buffer;
    }

    private Coordinate[] generateSegmentCurve(Coordinate p0, Coordinate p1, double width0, double width1) {
        LineSegment seg = new LineSegment(p0, p1);
        double dist0 = width0 / 2.0;
        double dist1 = width1 / 2.0;
        Coordinate s0 = seg.pointAlongOffset(0.0, dist0);
        Coordinate s1 = seg.pointAlongOffset(1.0, dist1);
        Coordinate s2 = seg.pointAlongOffset(1.0, -dist1);
        Coordinate s3 = seg.pointAlongOffset(0.0, -dist0);
        Coordinate[] pts = new Coordinate[]{s0, s1, s2, s3, s0};
        return pts;
    }
}

