/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceManager {
    private static final Object FAKE_BUNDLE = new Object();
    private static final Map<String, Object> bundles = Collections.synchronizedMap(new HashMap());

    public static String getMessage(String packageName, String messageKey) {
        return ResourceManager.getMessage(packageName, messageKey, Locale.getDefault(), null);
    }

    public static String getMessage(String packageName, String messageKey, Object data) {
        return ResourceManager.getMessage(packageName, messageKey, Locale.getDefault(), data);
    }

    public static String getMessage(String packageName, String messageKey, Locale locale) {
        return ResourceManager.getMessage(packageName, messageKey, locale, null);
    }

    public static String getMessage(String packageName, String messageKey, Locale locale, Object data) {
        Object obj = bundles.get(packageName + '|' + locale);
        if (obj == null) {
            try {
                obj = ResourceBundle.getBundle(packageName + ".Resources", locale);
            }
            catch (MissingResourceException mre) {
                obj = FAKE_BUNDLE;
            }
            bundles.put(packageName + '|' + locale, obj);
        }
        if (obj == FAKE_BUNDLE) {
            return "resource " + packageName + '.' + messageKey + " not found for locale " + locale;
        }
        try {
            String result = ((ResourceBundle)obj).getString(messageKey);
            return data == null ? result : ResourceManager.processParams(result, data);
        }
        catch (MissingResourceException mre) {
            return "resource " + packageName + '.' + messageKey + " not found for locale " + locale;
        }
    }

    private static String processParams(String str, Object data) {
        String result = str;
        if (data != null && data.getClass().isArray()) {
            Object[] params = (Object[])data;
            for (int i = 0; i < params.length; ++i) {
                result = ResourceManager.replaceAll(result, "{" + i + "}", "" + params[i]);
            }
        } else if (data instanceof Collection) {
            int i = 0;
            for (Object object : (Collection)data) {
                result = ResourceManager.replaceAll(result, "{" + i++ + "}", "" + object);
            }
        } else {
            result = ResourceManager.replaceAll(result, "{0}", "" + data);
        }
        return result;
    }

    private static String replaceAll(String str, String from, String to) {
        String result = str;
        int p = 0;
        while ((p = result.indexOf(from, p)) != -1) {
            result = result.substring(0, p) + to + result.substring(p + from.length());
            p += to.length();
        }
        return result;
    }

    private ResourceManager() {
    }
}

