/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.NumericConverterFactory;

public class PercentageConverterFactory
implements ConverterFactory {
    static final PercentageConverter INSTANCE = new PercentageConverter();

    public Converter createConverter(Class source, Class target, Hints hints) {
        target = NumericConverterFactory.primitiveToWrapperClass(target);
        if (!String.class.isAssignableFrom(source)) {
            return null;
        }
        if (Double.class.equals((Object)target) || Float.class.equals((Object)target)) {
            return INSTANCE;
        }
        return null;
    }

    static class PercentageConverter
    implements Converter {
        PercentageConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            String s2 = (String)source;
            if (!s2.endsWith("%")) {
                return null;
            }
            String number = s2.substring(0, s2.length() - 1);
            if (Double.class.equals(target)) {
                double value = Double.valueOf(number);
                return (T)new Double(value / 100.0);
            }
            if (Float.class.equals(target)) {
                float value = Float.valueOf(number).floatValue();
                return (T)new Float(value / 100.0f);
            }
            return null;
        }
    }
}

