/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Collection;
import java.util.Date;
import org.geotools.util.Utilities;
import org.opengis.temporal.OrdinalEra;
import org.opengis.util.InternationalString;

public class DefaultOrdinalEra
implements OrdinalEra {
    private InternationalString name;
    private Date beginning;
    private Date end;
    private Collection<OrdinalEra> composition;
    private DefaultOrdinalEra group;

    public DefaultOrdinalEra(InternationalString name, Date beginning, Date end) {
        if (!beginning.before(end)) {
            throw new IllegalArgumentException("The beginning date of the OrdinalEra must be less than (i.e. earlier than) the end date of this OrdinalEra.");
        }
        this.name = name;
        this.beginning = beginning;
        this.end = end;
    }

    public DefaultOrdinalEra(InternationalString name, Date beginning, Date end, Collection<OrdinalEra> composition) {
        this.name = name;
        this.beginning = beginning;
        this.end = end;
        for (OrdinalEra ordinalEra : composition) {
            ((DefaultOrdinalEra)ordinalEra).setGroup(this);
        }
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    @Override
    public Date getBeginning() {
        return this.beginning;
    }

    @Override
    public Date getEnd() {
        return this.end;
    }

    @Override
    public Collection<OrdinalEra> getComposition() {
        return this.composition;
    }

    public void setName(InternationalString name) {
        this.name = name;
    }

    public void setBeginning(Date beginning) {
        this.beginning = beginning;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public DefaultOrdinalEra getGroup() {
        return this.group;
    }

    public void setGroup(DefaultOrdinalEra group) {
        this.group = group;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultOrdinalEra) {
            DefaultOrdinalEra that = (DefaultOrdinalEra)object;
            return Utilities.equals(this.beginning, that.beginning) && Utilities.equals(this.end, that.end) && Utilities.equals(this.composition, that.composition) && Utilities.equals(this.group, that.group) && Utilities.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.beginning != null ? this.beginning.hashCode() : 0);
        hash = 37 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 37 * hash + (this.composition != null ? this.composition.hashCode() : 0);
        hash = 37 * hash + (this.group != null ? this.group.hashCode() : 0);
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("OrdinalEra:").append('\n');
        if (this.name != null) {
            s2.append("name:").append(this.name).append('\n');
        }
        if (this.beginning != null) {
            s2.append("beginning:").append(this.beginning).append('\n');
        }
        if (this.end != null) {
            s2.append("end:").append(this.end).append('\n');
        }
        if (this.composition != null) {
            s2.append("composition:").append(this.composition).append('\n');
        }
        if (this.group != null) {
            s2.append("group:").append(this.group).append('\n');
        }
        return s2.toString();
    }
}

