/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class PolarStereographicHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        MapProjection mapProjection = CRS.getMapProjection(renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof PolarStereographic) {
            boolean north;
            ParameterValue<?> stdParallel = null;
            try {
                stdParallel = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.STANDARD_PARALLEL_1.getName().getCode());
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                // empty catch block
            }
            if (stdParallel != null) {
                north = stdParallel.doubleValue() > 0.0;
            } else {
                ParameterValue<?> latOrigin = null;
                try {
                    latOrigin = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().getCode());
                }
                catch (ParameterNotFoundException parameterNotFoundException) {
                    // empty catch block
                }
                if (latOrigin != null) {
                    north = latOrigin.doubleValue() > 0.0;
                } else {
                    return null;
                }
            }
            ReferencedEnvelope validArea = north ? new ReferencedEnvelope(-2.147483647E9, 2.147483647E9, 0.0, 90.0, DefaultGeographicCRS.WGS84) : new ReferencedEnvelope(-2.147483647E9, 2.147483647E9, -90.0, 0.0, DefaultGeographicCRS.WGS84);
            return new ProjectionHandler(sourceCrs, validArea, renderingEnvelope){

                @Override
                public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
                    List<ReferencedEnvelope> envelopes;
                    if (!north && this.renderingEnvelope.getMaxY() < 0.0 && this.renderingEnvelope.getMinX() < 0.0 && this.renderingEnvelope.getMaxX() > 0.0) {
                        ReferencedEnvelope e1 = new ReferencedEnvelope(this.renderingEnvelope.getMinX(), -1.0E-6, this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getCoordinateReferenceSystem());
                        ReferencedEnvelope e2 = new ReferencedEnvelope(1.0E-6, this.renderingEnvelope.getMaxX(), this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getCoordinateReferenceSystem());
                        envelopes = new ArrayList<ReferencedEnvelope>();
                        envelopes.add(e1);
                        envelopes.add(e2);
                        this.reprojectEnvelopes(this.sourceCRS, envelopes);
                    } else if (north && this.renderingEnvelope.getMinY() > 0.0 && this.renderingEnvelope.getMinX() < 0.0 && this.renderingEnvelope.getMaxX() > 0.0) {
                        ReferencedEnvelope e1 = new ReferencedEnvelope(this.renderingEnvelope.getMinX(), -1.0E-6, this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getCoordinateReferenceSystem());
                        ReferencedEnvelope e2 = new ReferencedEnvelope(1.0E-6, this.renderingEnvelope.getMaxX(), this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getCoordinateReferenceSystem());
                        envelopes = new ArrayList<ReferencedEnvelope>();
                        envelopes.add(e1);
                        envelopes.add(e2);
                        this.reprojectEnvelopes(this.sourceCRS, envelopes);
                    } else {
                        envelopes = super.getQueryEnvelopes();
                    }
                    return envelopes;
                }
            };
        }
        return null;
    }
}

