/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.List;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MathTransformBuilder;
import org.geotools.referencing.operation.builder.MissingInfoException;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;

public class ProjectiveTransformBuilder
extends MathTransformBuilder {
    protected GeneralMatrix A;
    protected GeneralMatrix P = null;
    protected GeneralMatrix X;

    protected ProjectiveTransformBuilder() {
    }

    public ProjectiveTransformBuilder(List<MappedPosition> vectors) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException {
        super.setMappedPositions(vectors);
    }

    @Override
    public int getMinimumPointCount() {
        return 4;
    }

    public Class<? extends CartesianCS> getCoordinateSystemType() {
        return CartesianCS.class;
    }

    protected void fillPMatrix() throws MissingInfoException {
        this.P = new GeneralMatrix(this.getMappedPositions().size() * 2, this.getMappedPositions().size() * 2);
        for (int i = 0; i < this.getMappedPositions().size(); i += 2) {
            if (Double.compare(this.getMappedPositions().get(i).getAccuracy(), Double.NaN) == 0) {
                throw new MissingInfoException("Accuracy has to be defined for all points");
            }
            this.P.setElement(i, i, 1.0 / this.getMappedPositions().get(i).getAccuracy());
            this.P.setElement(i + 1, i + 1, 1.0 / this.getMappedPositions().get(i).getAccuracy());
        }
    }

    protected void fillAMatrix() {
        double ys;
        double xs;
        int j;
        DirectPosition[] sourcePoints = this.getSourcePoints();
        DirectPosition[] targetPoints = this.getTargetPoints();
        this.A = new GeneralMatrix(2 * sourcePoints.length, 8);
        int numRow = 2 * sourcePoints.length;
        for (j = 0; j < 2 * sourcePoints.length / 2; ++j) {
            xs = sourcePoints[j].getCoordinate()[0];
            ys = sourcePoints[j].getCoordinate()[1];
            double xd = targetPoints[j].getCoordinate()[0];
            this.A.setRow(j, xs, ys, 1.0, 0.0, 0.0, 0.0, -xd * xs, -xd * ys);
        }
        for (j = numRow / 2; j < numRow; ++j) {
            xs = sourcePoints[j - numRow / 2].getCoordinate()[0];
            ys = sourcePoints[j - numRow / 2].getCoordinate()[1];
            double yd = targetPoints[j - numRow / 2].getCoordinate()[1];
            this.A.setRow(j, 0.0, 0.0, 0.0, xs, ys, 1.0, -yd * xs, -yd * ys);
        }
    }

    protected void fillXMatrix() {
        int j;
        this.X = new GeneralMatrix(2 * this.getTargetPoints().length, 1);
        int numRow = this.X.getNumRow();
        for (j = 0; j < numRow / 2; ++j) {
            this.X.setElement(j, 0, this.getTargetPoints()[j].getCoordinate()[0]);
        }
        for (j = numRow / 2; j < numRow; ++j) {
            this.X.setElement(j, 0, this.getTargetPoints()[j - numRow / 2].getCoordinate()[1]);
        }
    }

    public void includeWeights(boolean include) throws MissingInfoException {
        this.P = new GeneralMatrix(this.getMappedPositions().size() * 2, this.getMappedPositions().size() * 2);
        if (include) {
            this.fillPMatrix();
        } else {
            for (int j = 0; j < this.getMappedPositions().size(); ++j) {
                this.P.setElement(j, j, 1.0);
            }
        }
    }

    protected double[] calculateLSM() {
        this.fillAMatrix();
        this.fillXMatrix();
        if (this.P == null) {
            try {
                this.includeWeights(false);
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
        }
        GeneralMatrix AT = this.A.clone();
        AT.transpose();
        GeneralMatrix ATP = new GeneralMatrix(AT.getNumRow(), this.P.getNumCol());
        GeneralMatrix ATPA = new GeneralMatrix(AT.getNumRow(), this.A.getNumCol());
        GeneralMatrix ATPX = new GeneralMatrix(AT.getNumRow(), 1);
        GeneralMatrix x = new GeneralMatrix(this.A.getNumCol(), 1);
        ATP.mul(AT, (Matrix)this.P);
        ATPA.mul(ATP, (Matrix)this.A);
        ATPX.mul(ATP, (Matrix)this.X);
        ATPA.invert();
        x.mul(ATPA, (Matrix)ATPX);
        ATPA.invert();
        x.transpose();
        return x.getElements()[0];
    }

    protected GeneralMatrix getProjectiveMatrix() {
        GeneralMatrix M2 = new GeneralMatrix(3, 3);
        double[] param = this.calculateLSM();
        double[] m0 = new double[]{param[0], param[1], param[2]};
        double[] m1 = new double[]{param[3], param[4], param[5]};
        double[] m22 = new double[]{param[6], param[7], 1.0};
        M2.setRow(0, m0);
        M2.setRow(1, m1);
        M2.setRow(2, m22);
        return M2;
    }

    @Override
    protected MathTransform computeMathTransform() {
        return ProjectiveTransform.create(this.getProjectiveMatrix());
    }
}

