/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import java.util.ArrayList;
import org.geotools.gml.SubHandler;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.TopologyException;

public class SubHandlerLinearRing
extends SubHandler {
    private ArrayList coordinateList = new ArrayList();

    @Override
    public void addCoordinate(Coordinate coordinate) {
        this.coordinateList.add(coordinate);
    }

    @Override
    public boolean isComplete(String message) {
        if (this.coordinateList.size() > 1) {
            Coordinate firstCoordinate = (Coordinate)this.coordinateList.get(0);
            Coordinate lastCoordinate = (Coordinate)this.coordinateList.get(this.coordinateList.size() - 1);
            return lastCoordinate.equals2D(firstCoordinate);
        }
        return false;
    }

    @Override
    public Geometry create(GeometryFactory geometryFactory) {
        try {
            Coordinate[] coords = this.coordinateList.toArray(new Coordinate[this.coordinateList.size()]);
            LinearRing ring = geometryFactory.createLinearRing(coords);
            ring.setUserData(this.getSRS());
            ring.setSRID(this.getSRID());
            return ring;
        }
        catch (TopologyException e) {
            System.err.println("Caught Topology exception in GMLLinearRingHandler");
            return null;
        }
    }
}

