/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;

public class DefaultCRSFilterVisitor
extends DuplicatingFilterVisitor {
    private CoordinateReferenceSystem defaultCrs;

    public DefaultCRSFilterVisitor(FilterFactory2 factory, CoordinateReferenceSystem defaultCrs) {
        super(factory);
        this.defaultCrs = defaultCrs;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        String srs = filter.getSRS();
        if (srs != null && !"".equals(srs.trim())) {
            return super.visit(filter, extraData);
        }
        if (this.defaultCrs == null || filter.getBounds() == null || this.defaultCrs.getCoordinateSystem().getDimension() == filter.getBounds().getDimension()) {
            return this.getFactory(extraData).bbox(filter.getExpression1(), ReferencedEnvelope.create(filter.getBounds(), this.defaultCrs));
        }
        try {
            SingleCRS horizontalCRS = CRS.getHorizontalCRS(this.defaultCrs);
            ReferencedEnvelope bounds = ReferencedEnvelope.create(filter.getBounds(), (CoordinateReferenceSystem)horizontalCRS);
            return this.getFactory(extraData).bbox(filter.getExpression1(), bounds);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode srs '" + srs + "'", e);
        }
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        if (!(expression.getValue() instanceof Geometry)) {
            return super.visit(expression, extraData);
        }
        Geometry geom = (Geometry)expression.getValue();
        if (geom.getUserData() != null && geom.getUserData() instanceof CoordinateReferenceSystem) {
            return super.visit(expression, extraData);
        }
        Geometry clone = geom.getFactory().createGeometry(geom);
        clone.setUserData(this.defaultCrs);
        return this.ff.literal(clone);
    }
}

