/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.index.quadtree.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.geotools.data.shapefile.index.quadtree.StoreException;
import org.geotools.util.logging.Logging;

public class IndexHeader {
    public static final byte LSB_ORDER = -1;
    public static final byte MSB_ORDER = -2;
    public static final byte NATIVE_ORDER = 0;
    public static final byte NEW_LSB_ORDER = 1;
    public static final byte NEW_MSB_ORDER = 2;
    private static final String SIGNATURE = "SQT";
    private static final byte VERSION = 1;
    private static final byte[] RESERVED = new byte[]{0, 0, 0};
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private byte byteOrder;

    public IndexHeader(byte byteOrder) {
        this.byteOrder = byteOrder;
    }

    public IndexHeader(ReadableByteChannel channel) throws IOException, StoreException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        channel.read(buf);
        buf.flip();
        byte[] tmp = new byte[3];
        buf.get(tmp);
        String s2 = new String(tmp, "US-ASCII");
        if (!s2.equals(SIGNATURE)) {
            LOGGER.warning("Old qix file format; this file format is deprecated; It is strongly recommended to regenerate it in new format.");
            buf.position(0);
            tmp = buf.array();
            boolean lsb = tmp[4] == 0 && tmp[5] == 0 && tmp[6] == 0 && tmp[7] == 0 ? tmp[0] != 0 || tmp[1] != 0 : tmp[4] != 0 || tmp[5] != 0;
            this.byteOrder = (byte)(lsb ? -1 : -2);
        } else {
            this.byteOrder = buf.get();
        }
    }

    public void writeTo(ByteBuffer buf) {
        Charset charSet = Charset.forName("US-ASCII");
        ByteBuffer tmp = charSet.encode(SIGNATURE);
        tmp.position(0);
        buf.put(tmp);
        buf.put(this.byteOrder);
        buf.put((byte)1);
        buf.put(RESERVED);
    }

    public byte getByteOrder() {
        return this.byteOrder;
    }
}

