/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row;

import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.SpecializedOps_DDRM;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQRP_DDRM;
import org.ejml.dense.row.linsol.qr.SolveNullSpaceQR_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;

public class SingularOps_DDRM {
    public static void descendingOrder(DMatrixRMaj U, boolean tranU, DMatrixRMaj W, DMatrixRMaj V, boolean tranV) {
        int numSingular = Math.min(W.numRows, W.numCols);
        SingularOps_DDRM.checkSvdMatrixSize(U, tranU, W, V, tranV);
        for (int i = 0; i < numSingular; ++i) {
            double bigValue = -1.0;
            int bigIndex = -1;
            for (int j = i; j < numSingular; ++j) {
                double v = W.get(j, j);
                if (!(v > bigValue)) continue;
                bigValue = v;
                bigIndex = j;
            }
            if (bigIndex == i) continue;
            if (bigIndex == -1) break;
            double tmp = W.get(i, i);
            W.set(i, i, bigValue);
            W.set(bigIndex, bigIndex, tmp);
            if (V != null) {
                SingularOps_DDRM.swapRowOrCol(V, tranV, i, bigIndex);
            }
            if (U == null) continue;
            SingularOps_DDRM.swapRowOrCol(U, tranU, i, bigIndex);
        }
    }

    public static void descendingOrder(DMatrixRMaj U, boolean tranU, double[] singularValues, int singularLength, DMatrixRMaj V, boolean tranV) {
        for (int i = 0; i < singularLength; ++i) {
            double bigValue = -1.0;
            int bigIndex = -1;
            for (int j = i; j < singularLength; ++j) {
                double v = singularValues[j];
                if (!(v > bigValue)) continue;
                bigValue = v;
                bigIndex = j;
            }
            if (bigIndex == i) continue;
            if (bigIndex == -1) break;
            double tmp = singularValues[i];
            singularValues[i] = bigValue;
            singularValues[bigIndex] = tmp;
            if (V != null) {
                SingularOps_DDRM.swapRowOrCol(V, tranV, i, bigIndex);
            }
            if (U == null) continue;
            SingularOps_DDRM.swapRowOrCol(U, tranU, i, bigIndex);
        }
    }

    public static void checkSvdMatrixSize(DMatrixRMaj U, boolean tranU, DMatrixRMaj W, DMatrixRMaj V, boolean tranV) {
        boolean compact;
        int numSingular = Math.min(W.numRows, W.numCols);
        boolean bl = compact = W.numRows == W.numCols;
        if (compact) {
            if (U != null) {
                if (tranU && U.numRows != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix U");
                }
                if (!tranU && U.numCols != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix U");
                }
            }
            if (V != null) {
                if (tranV && V.numRows != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix V");
                }
                if (!tranV && V.numCols != numSingular) {
                    throw new IllegalArgumentException("Unexpected size of matrix V");
                }
            }
        } else {
            if (U != null && U.numRows != U.numCols) {
                throw new IllegalArgumentException("Unexpected size of matrix U");
            }
            if (V != null && V.numRows != V.numCols) {
                throw new IllegalArgumentException("Unexpected size of matrix V");
            }
            if (U != null && U.numRows != W.numRows) {
                throw new IllegalArgumentException("Unexpected size of W");
            }
            if (V != null && V.numRows != W.numCols) {
                throw new IllegalArgumentException("Unexpected size of W");
            }
        }
    }

    private static void swapRowOrCol(DMatrixRMaj M2, boolean tran, int i, int bigIndex) {
        if (tran) {
            for (int col = 0; col < M2.numCols; ++col) {
                double tmp = M2.get(i, col);
                M2.set(i, col, M2.get(bigIndex, col));
                M2.set(bigIndex, col, tmp);
            }
        } else {
            for (int row = 0; row < M2.numRows; ++row) {
                double tmp = M2.get(row, i);
                M2.set(row, i, M2.get(row, bigIndex));
                M2.set(row, bigIndex, tmp);
            }
        }
    }

    public static DMatrixRMaj nullSpace(SingularValueDecomposition_F64<DMatrixRMaj> svd, DMatrixRMaj nullSpace, double tol) {
        int i;
        int N = svd.numberOfSingularValues();
        double[] s2 = svd.getSingularValues();
        DMatrixRMaj V = svd.getV(null, true);
        if (V.numRows != svd.numCols()) {
            throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
        }
        int numVectors = svd.numCols() - N;
        for (int i2 = 0; i2 < N; ++i2) {
            if (!(s2[i2] <= tol)) continue;
            ++numVectors;
        }
        if (nullSpace == null) {
            nullSpace = new DMatrixRMaj(numVectors, svd.numCols());
        } else {
            nullSpace.reshape(numVectors, svd.numCols());
        }
        int count = 0;
        for (i = 0; i < N; ++i) {
            if (!(s2[i] <= tol)) continue;
            CommonOps_DDRM.extract(V, i, i + 1, 0, V.numCols, nullSpace, count++, 0);
        }
        for (i = N; i < svd.numCols(); ++i) {
            CommonOps_DDRM.extract(V, i, i + 1, 0, V.numCols, nullSpace, count++, 0);
        }
        CommonOps_DDRM.transpose(nullSpace);
        return nullSpace;
    }

    public static DMatrixRMaj nullspaceQR(DMatrixRMaj A2, int totalSingular) {
        SolveNullSpaceQR_DDRM solver = new SolveNullSpaceQR_DDRM();
        DMatrixRMaj nullspace = new DMatrixRMaj(1, 1);
        if (!solver.process(A2, totalSingular, nullspace)) {
            throw new RuntimeException("Solver failed. try SVD based method instead?");
        }
        return nullspace;
    }

    public static DMatrixRMaj nullspaceQRP(DMatrixRMaj A2, int totalSingular) {
        SolveNullSpaceQRP_DDRM solver = new SolveNullSpaceQRP_DDRM();
        DMatrixRMaj nullspace = new DMatrixRMaj(1, 1);
        if (!solver.process(A2, totalSingular, nullspace)) {
            throw new RuntimeException("Solver failed. try SVD based method instead?");
        }
        return nullspace;
    }

    public static DMatrixRMaj nullspaceSVD(DMatrixRMaj A2, int totalSingular) {
        SolveNullSpaceSvd_DDRM solver = new SolveNullSpaceSvd_DDRM();
        DMatrixRMaj nullspace = new DMatrixRMaj(1, 1);
        if (!solver.process(A2, totalSingular, nullspace)) {
            throw new RuntimeException("Solver failed. try SVD based method instead?");
        }
        return nullspace;
    }

    public static DMatrixRMaj nullVector(SingularValueDecomposition_F64<DMatrixRMaj> svd, boolean isRight, DMatrixRMaj nullVector) {
        DMatrixRMaj A2;
        int N = svd.numberOfSingularValues();
        double[] s2 = svd.getSingularValues();
        DMatrixRMaj dMatrixRMaj = A2 = isRight ? (DMatrixRMaj)svd.getV(null, true) : (DMatrixRMaj)svd.getU(null, false);
        if (isRight) {
            if (A2.numRows != svd.numCols()) {
                throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
            }
            if (nullVector == null) {
                nullVector = new DMatrixRMaj(svd.numCols(), 1);
            }
        } else {
            if (A2.numCols != svd.numRows()) {
                throw new IllegalArgumentException("Can't compute the null space using a compact SVD for a matrix of this size.");
            }
            if (nullVector == null) {
                nullVector = new DMatrixRMaj(svd.numRows(), 1);
            }
        }
        int smallestIndex = -1;
        if (isRight && svd.numCols() > svd.numRows()) {
            smallestIndex = svd.numCols() - 1;
        } else if (!isRight && svd.numCols() < svd.numRows()) {
            smallestIndex = svd.numRows() - 1;
        } else {
            double smallestValue = Double.MAX_VALUE;
            for (int i = 0; i < N; ++i) {
                if (!(s2[i] < smallestValue)) continue;
                smallestValue = s2[i];
                smallestIndex = i;
            }
        }
        if (isRight) {
            SpecializedOps_DDRM.subvector(A2, smallestIndex, 0, A2.numRows, true, 0, nullVector);
        } else {
            SpecializedOps_DDRM.subvector(A2, 0, smallestIndex, A2.numRows, false, 0, nullVector);
        }
        return nullVector;
    }

    public static double singularThreshold(SingularValueDecomposition_F64 svd) {
        double largest = 0.0;
        double[] w = svd.getSingularValues();
        int N = svd.numberOfSingularValues();
        for (int j = 0; j < N; ++j) {
            if (!(w[j] > largest)) continue;
            largest = w[j];
        }
        int M2 = Math.max(svd.numCols(), svd.numRows());
        return (double)M2 * largest * UtilEjml.EPS;
    }

    public static int rank(SingularValueDecomposition_F64 svd) {
        double threshold = SingularOps_DDRM.singularThreshold(svd);
        return SingularOps_DDRM.rank(svd, threshold);
    }

    public static int rank(SingularValueDecomposition_F64 svd, double threshold) {
        int numRank = 0;
        double[] w = svd.getSingularValues();
        int N = svd.numberOfSingularValues();
        for (int j = 0; j < N; ++j) {
            if (!(w[j] > threshold)) continue;
            ++numRank;
        }
        return numRank;
    }

    public static int nullity(SingularValueDecomposition_F64 svd) {
        double threshold = SingularOps_DDRM.singularThreshold(svd);
        return SingularOps_DDRM.nullity(svd, threshold);
    }

    public static int nullity(SingularValueDecomposition_F64 svd, double threshold) {
        int ret = 0;
        double[] w = svd.getSingularValues();
        int N = svd.numberOfSingularValues();
        int numCol = svd.numCols();
        for (int j = 0; j < N; ++j) {
            if (!(w[j] <= threshold)) continue;
            ++ret;
        }
        return ret + numCol - N;
    }
}

