/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.fixed;

import org.ejml.data.DMatrix6;
import org.ejml.data.DMatrix6x6;
import org.ejml.dense.fixed.CommonOps_DDF6;

public class NormOps_DDF6 {
    public static void normalizeF(DMatrix6x6 M2) {
        double val = NormOps_DDF6.normF(M2);
        CommonOps_DDF6.divide(M2, val);
    }

    public static void normalizeF(DMatrix6 M2) {
        double val = NormOps_DDF6.normF(M2);
        CommonOps_DDF6.divide(M2, val);
    }

    public static double fastNormF(DMatrix6x6 M2) {
        double sum = 0.0;
        sum += M2.a11 * M2.a11 + M2.a12 * M2.a12 + M2.a13 * M2.a13 + M2.a14 * M2.a14 + M2.a15 * M2.a15 + M2.a16 * M2.a16;
        sum += M2.a21 * M2.a21 + M2.a22 * M2.a22 + M2.a23 * M2.a23 + M2.a24 * M2.a24 + M2.a25 * M2.a25 + M2.a26 * M2.a26;
        sum += M2.a31 * M2.a31 + M2.a32 * M2.a32 + M2.a33 * M2.a33 + M2.a34 * M2.a34 + M2.a35 * M2.a35 + M2.a36 * M2.a36;
        sum += M2.a41 * M2.a41 + M2.a42 * M2.a42 + M2.a43 * M2.a43 + M2.a44 * M2.a44 + M2.a45 * M2.a45 + M2.a46 * M2.a46;
        sum += M2.a51 * M2.a51 + M2.a52 * M2.a52 + M2.a53 * M2.a53 + M2.a54 * M2.a54 + M2.a55 * M2.a55 + M2.a56 * M2.a56;
        return Math.sqrt(sum += M2.a61 * M2.a61 + M2.a62 * M2.a62 + M2.a63 * M2.a63 + M2.a64 * M2.a64 + M2.a65 * M2.a65 + M2.a66 * M2.a66);
    }

    public static double fastNormF(DMatrix6 M2) {
        double sum = M2.a1 * M2.a1 + M2.a2 * M2.a2 + M2.a3 * M2.a3 + M2.a4 * M2.a4 + M2.a5 * M2.a5 + M2.a6 * M2.a6;
        return Math.sqrt(sum);
    }

    public static double normF(DMatrix6x6 M2) {
        double scale = CommonOps_DDF6.elementMaxAbs(M2);
        if (scale == 0.0) {
            return 0.0;
        }
        double a11 = M2.a11 / scale;
        double a12 = M2.a12 / scale;
        double a13 = M2.a13 / scale;
        double a14 = M2.a14 / scale;
        double a15 = M2.a15 / scale;
        double a16 = M2.a16 / scale;
        double a21 = M2.a21 / scale;
        double a22 = M2.a22 / scale;
        double a23 = M2.a23 / scale;
        double a24 = M2.a24 / scale;
        double a25 = M2.a25 / scale;
        double a26 = M2.a26 / scale;
        double a31 = M2.a31 / scale;
        double a32 = M2.a32 / scale;
        double a33 = M2.a33 / scale;
        double a34 = M2.a34 / scale;
        double a35 = M2.a35 / scale;
        double a36 = M2.a36 / scale;
        double a41 = M2.a41 / scale;
        double a42 = M2.a42 / scale;
        double a43 = M2.a43 / scale;
        double a44 = M2.a44 / scale;
        double a45 = M2.a45 / scale;
        double a46 = M2.a46 / scale;
        double a51 = M2.a51 / scale;
        double a52 = M2.a52 / scale;
        double a53 = M2.a53 / scale;
        double a54 = M2.a54 / scale;
        double a55 = M2.a55 / scale;
        double a56 = M2.a56 / scale;
        double a61 = M2.a61 / scale;
        double a62 = M2.a62 / scale;
        double a63 = M2.a63 / scale;
        double a64 = M2.a64 / scale;
        double a65 = M2.a65 / scale;
        double a66 = M2.a66 / scale;
        double sum = 0.0;
        sum += a11 * a11 + a12 * a12 + a13 * a13 + a14 * a14 + a15 * a15 + a16 * a16;
        sum += a21 * a21 + a22 * a22 + a23 * a23 + a24 * a24 + a25 * a25 + a26 * a26;
        sum += a31 * a31 + a32 * a32 + a33 * a33 + a34 * a34 + a35 * a35 + a36 * a36;
        sum += a41 * a41 + a42 * a42 + a43 * a43 + a44 * a44 + a45 * a45 + a46 * a46;
        sum += a51 * a51 + a52 * a52 + a53 * a53 + a54 * a54 + a55 * a55 + a56 * a56;
        return scale * Math.sqrt(sum += a61 * a61 + a62 * a62 + a63 * a63 + a64 * a64 + a65 * a65 + a66 * a66);
    }

    public static double normF(DMatrix6 M2) {
        double scale = CommonOps_DDF6.elementMaxAbs(M2);
        if (scale == 0.0) {
            return 0.0;
        }
        double a1 = M2.a1 / scale;
        double a2 = M2.a2 / scale;
        double a3 = M2.a3 / scale;
        double a4 = M2.a4 / scale;
        double a5 = M2.a5 / scale;
        double a6 = M2.a6 / scale;
        double sum = a1 * a1 + a2 * a2 + a3 * a3 + a4 * a4 + a5 * a5 + a6 * a6;
        return scale * Math.sqrt(sum);
    }
}

