/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.fixed;

import org.ejml.data.DMatrix3;
import org.ejml.data.DMatrix3x3;
import org.ejml.dense.fixed.CommonOps_DDF3;

public class NormOps_DDF3 {
    public static void normalizeF(DMatrix3x3 M2) {
        double val = NormOps_DDF3.normF(M2);
        CommonOps_DDF3.divide(M2, val);
    }

    public static void normalizeF(DMatrix3 M2) {
        double val = NormOps_DDF3.normF(M2);
        CommonOps_DDF3.divide(M2, val);
    }

    public static double fastNormF(DMatrix3x3 M2) {
        double sum = 0.0;
        sum += M2.a11 * M2.a11 + M2.a12 * M2.a12 + M2.a13 * M2.a13;
        sum += M2.a21 * M2.a21 + M2.a22 * M2.a22 + M2.a23 * M2.a23;
        return Math.sqrt(sum += M2.a31 * M2.a31 + M2.a32 * M2.a32 + M2.a33 * M2.a33);
    }

    public static double fastNormF(DMatrix3 M2) {
        double sum = M2.a1 * M2.a1 + M2.a2 * M2.a2 + M2.a3 * M2.a3;
        return Math.sqrt(sum);
    }

    public static double normF(DMatrix3x3 M2) {
        double scale = CommonOps_DDF3.elementMaxAbs(M2);
        if (scale == 0.0) {
            return 0.0;
        }
        double a11 = M2.a11 / scale;
        double a12 = M2.a12 / scale;
        double a13 = M2.a13 / scale;
        double a21 = M2.a21 / scale;
        double a22 = M2.a22 / scale;
        double a23 = M2.a23 / scale;
        double a31 = M2.a31 / scale;
        double a32 = M2.a32 / scale;
        double a33 = M2.a33 / scale;
        double sum = 0.0;
        sum += a11 * a11 + a12 * a12 + a13 * a13;
        sum += a21 * a21 + a22 * a22 + a23 * a23;
        return scale * Math.sqrt(sum += a31 * a31 + a32 * a32 + a33 * a33);
    }

    public static double normF(DMatrix3 M2) {
        double scale = CommonOps_DDF3.elementMaxAbs(M2);
        if (scale == 0.0) {
            return 0.0;
        }
        double a1 = M2.a1 / scale;
        double a2 = M2.a2 / scale;
        double a3 = M2.a3 / scale;
        double sum = a1 * a1 + a2 * a2 + a3 * a3;
        return scale * Math.sqrt(sum);
    }
}

