/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.HasName;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AnnotationInfo
extends ScanResultObject
implements Comparable<AnnotationInfo>,
HasName {
    private String name;
    AnnotationParameterValueList annotationParamValues;
    private transient boolean annotationParamValuesHasBeenConvertedToPrimitive;
    private transient AnnotationParameterValueList annotationParamValuesWithDefaults;

    AnnotationInfo() {
    }

    AnnotationInfo(String name, AnnotationParameterValueList annotationParamValues) {
        this.name = name;
        this.annotationParamValues = annotationParamValues;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isInherited() {
        return this.getClassInfo().isInherited;
    }

    public AnnotationParameterValueList getDefaultParameterValues() {
        return this.getClassInfo().getAnnotationDefaultParameterValues();
    }

    public AnnotationParameterValueList getParameterValues() {
        if (this.annotationParamValuesWithDefaults == null) {
            AnnotationParameterValueList defaultParamValues;
            ClassInfo classInfo = this.getClassInfo();
            if (classInfo == null) {
                return this.annotationParamValues == null ? AnnotationParameterValueList.EMPTY_LIST : this.annotationParamValues;
            }
            if (this.annotationParamValues != null && !this.annotationParamValuesHasBeenConvertedToPrimitive) {
                this.annotationParamValues.convertWrapperArraysToPrimitiveArrays(classInfo);
                this.annotationParamValuesHasBeenConvertedToPrimitive = true;
            }
            if (classInfo.annotationDefaultParamValues != null && !classInfo.annotationDefaultParamValuesHasBeenConvertedToPrimitive) {
                classInfo.annotationDefaultParamValues.convertWrapperArraysToPrimitiveArrays(classInfo);
                classInfo.annotationDefaultParamValuesHasBeenConvertedToPrimitive = true;
            }
            if ((defaultParamValues = classInfo.annotationDefaultParamValues) == null && this.annotationParamValues == null) {
                return AnnotationParameterValueList.EMPTY_LIST;
            }
            if (defaultParamValues == null) {
                return this.annotationParamValues;
            }
            if (this.annotationParamValues == null) {
                return defaultParamValues;
            }
            HashMap<String, Object> allParamValues = new HashMap<String, Object>();
            for (AnnotationParameterValue annotationParameterValue : defaultParamValues) {
                allParamValues.put(annotationParameterValue.getName(), annotationParameterValue.getValue());
            }
            for (AnnotationParameterValue annotationParameterValue : this.annotationParamValues) {
                allParamValues.put(annotationParameterValue.getName(), annotationParameterValue.getValue());
            }
            this.annotationParamValuesWithDefaults = new AnnotationParameterValueList();
            for (Map.Entry entry : allParamValues.entrySet()) {
                this.annotationParamValuesWithDefaults.add(new AnnotationParameterValue((String)entry.getKey(), entry.getValue()));
            }
            Collections.sort(this.annotationParamValuesWithDefaults);
        }
        return this.annotationParamValuesWithDefaults;
    }

    @Override
    protected String getClassName() {
        return this.name;
    }

    @Override
    public ClassInfo getClassInfo() {
        this.getClassName();
        return super.getClassInfo();
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.annotationParamValues != null) {
            for (AnnotationParameterValue a : this.annotationParamValues) {
                a.setScanResult(scanResult);
            }
        }
    }

    @Override
    void getReferencedClassNames(Set<String> classNames) {
        classNames.add(this.name);
        if (this.annotationParamValues != null) {
            for (AnnotationParameterValue annotationParamValue : this.annotationParamValues) {
                annotationParamValue.getReferencedClassNames(classNames);
            }
        }
    }

    public Annotation loadClassAndInstantiate() {
        Class<Annotation> annotationClass = this.getClassInfo().loadClass(Annotation.class);
        return (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationInvocationHandler(annotationClass, this));
    }

    void convertWrapperArraysToPrimitiveArrays() {
        if (this.annotationParamValues != null) {
            this.annotationParamValues.convertWrapperArraysToPrimitiveArrays(this.getClassInfo());
        }
    }

    @Override
    public int compareTo(AnnotationInfo o) {
        int diff = this.getName().compareTo(o.getName());
        if (diff != 0) {
            return diff;
        }
        if (this.annotationParamValues == null && o.annotationParamValues == null) {
            return 0;
        }
        if (this.annotationParamValues == null) {
            return -1;
        }
        if (o.annotationParamValues == null) {
            return 1;
        }
        int max = Math.max(this.annotationParamValues.size(), o.annotationParamValues.size());
        for (int i = 0; i < max; ++i) {
            if (i >= this.annotationParamValues.size()) {
                return -1;
            }
            if (i >= o.annotationParamValues.size()) {
                return 1;
            }
            int diff2 = ((AnnotationParameterValue)this.annotationParamValues.get(i)).compareTo((AnnotationParameterValue)o.annotationParamValues.get(i));
            if (diff2 == 0) continue;
            return diff2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotationInfo)) {
            return false;
        }
        AnnotationInfo o = (AnnotationInfo)obj;
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        int h2 = this.getName().hashCode();
        if (this.annotationParamValues != null) {
            for (AnnotationParameterValue e : this.annotationParamValues) {
                h2 = h2 * 7 + e.getName().hashCode() * 3 + e.getValue().hashCode();
            }
        }
        return h2;
    }

    void toString(StringBuilder buf) {
        buf.append("@").append(this.getName());
        if (this.annotationParamValues != null && !this.annotationParamValues.isEmpty()) {
            buf.append('(');
            for (int i = 0; i < this.annotationParamValues.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                AnnotationParameterValue annotationParamValue = (AnnotationParameterValue)this.annotationParamValues.get(i);
                if (this.annotationParamValues.size() > 1 || !"value".equals(annotationParamValue.getName())) {
                    annotationParamValue.toString(buf);
                    continue;
                }
                annotationParamValue.toStringParamValueOnly(buf);
            }
            buf.append(')');
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    private static class AnnotationInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final Class<? extends Annotation> annotationClass;
        private final Map<String, Object> annotationParameterValuesInstantiated = new HashMap<String, Object>();
        private final String toString;

        AnnotationInvocationHandler(Class<? extends Annotation> annotationClass, AnnotationInfo annotationInfo) {
            this.annotationClass = annotationClass;
            this.toString = annotationInfo.toString();
            for (AnnotationParameterValue apv : annotationInfo.getParameterValues()) {
                Object instantiatedValue = apv.instantiate(annotationInfo.getClassInfo());
                if (instantiatedValue == null) {
                    throw new IllegalArgumentException("Got null value for annotation parameter " + apv.getName() + " of annotation " + annotationInfo.getName());
                }
                this.annotationParameterValuesInstantiated.put(apv.getName(), instantiatedValue);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 1) {
                if (methodName.equals("equals") && paramTypes[0] == Object.class) {
                    return args[0] != null && args[0] instanceof AnnotationInvocationHandler && ((AnnotationInvocationHandler)args[0]).annotationClass == this.annotationClass && ((AnnotationInvocationHandler)args[0]).annotationParameterValuesInstantiated.equals(this.annotationParameterValuesInstantiated);
                }
                throw new IllegalArgumentException();
            }
            if (paramTypes.length == 0) {
                switch (methodName) {
                    case "toString": {
                        return this.toString;
                    }
                    case "hashCode": {
                        return this.toString.hashCode();
                    }
                    case "annotationType": {
                        return this.annotationClass;
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
            Object annotationParameterValue = this.annotationParameterValuesInstantiated.get(methodName);
            if (annotationParameterValue == null) {
                throw new IncompleteAnnotationException(this.annotationClass, methodName);
            }
            Class<?> annotationParameterValueClass = annotationParameterValue.getClass();
            if (annotationParameterValueClass.isArray()) {
                if (annotationParameterValueClass == String[].class) {
                    return ((String[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == byte[].class) {
                    return ((byte[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == char[].class) {
                    return ((char[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == double[].class) {
                    return ((double[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == float[].class) {
                    return ((float[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == int[].class) {
                    return ((int[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == long[].class) {
                    return ((long[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == short[].class) {
                    return ((short[])annotationParameterValue).clone();
                }
                if (annotationParameterValueClass == boolean[].class) {
                    return ((boolean[])annotationParameterValue).clone();
                }
                Object[] arr = (Object[])annotationParameterValue;
                return arr.clone();
            }
            return annotationParameterValue;
        }
    }
}

