/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.osmosis;

import crosby.binary.osmosis.OsmosisBinaryParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.osmbinary.file.BlockInputStream;

public class OsmosisReader
implements RunnableSource {
    private Sink sink;
    InputStream input;
    OsmosisBinaryParser parser;

    public OsmosisReader(InputStream input) {
        if (input == null) {
            throw new Error("Null input");
        }
        this.input = input;
        this.parser = new OsmosisBinaryParser();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
        this.parser.setSink(sink);
    }

    @Override
    public void run() {
        try {
            this.sink.initialize(Collections.<String, Object>emptyMap());
            new BlockInputStream(this.input, this.parser).process();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to process PBF stream", e);
        }
        finally {
            this.sink.release();
        }
    }
}

