/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.database;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.database.DatabaseConnection;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.flag.serializer.CheckFlagDeserializer;
import org.openstreetmap.atlas.checks.utility.FileUtility;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.init.ScriptUtils;

public class FlagDatabaseSubCommand
extends AbstractAtlasShellToolsCommand {
    private static final String FLAG_PATH_INPUT = "flag_path";
    private static final String DATABASE_URL_INPUT = "database_url";
    private static final String RUN_URI_INPUT = "run_uri";
    private static final String SOFTWARE_VERSION_INPUT = "software_version";
    private static final String ISO_COUNTRY_CODE = "iso_country_code";
    private static final String OSM_ID_LEGACY = "osmid";
    private static final String CREATE_FLAG_SQL = "INSERT INTO flag(flag_id, check_name, instructions, run_uri, software_version, date_created) VALUES (?,?,?,?,?,?);";
    private static final String CREATE_FEATURE_SQL = String.format("INSERT INTO feature (flag_id, geom, osm_id, atlas_id, iso_country_code, tags, item_type, date_created) VALUES (?,%s,?,?,?,?);", "ST_GeomFromGeoJSON(?), ?, ?");
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final int SEVEN = 7;
    private static final int EIGHT = 8;
    private static final int BATCH_SIZE = 1000;
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(CheckFlag.class, (Object)new CheckFlagDeserializer()).create();
    private static final Logger logger = LoggerFactory.getLogger(FlagDatabaseSubCommand.class);
    private static final Set<String> blacklistKeys = new HashSet<String>();
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private Timestamp timestamp;

    public static void main(String[] args) {
        new FlagDatabaseSubCommand().runSubcommandAndExit(args);
    }

    public void batchFlagFeatureStatement(PreparedStatement sql, CheckFlag flag, int flagIdentifier, JsonObject feature) {
        JsonObject properties = feature.get("properties").getAsJsonObject();
        try {
            sql.setInt(1, flagIdentifier);
            sql.setString(2, feature.get("geometry").toString());
            sql.setLong(3, this.getOsmIdentifier(properties));
            sql.setLong(4, properties.get("identifier").getAsLong());
            sql.setString(5, properties.has(ISO_COUNTRY_CODE) ? properties.get(ISO_COUNTRY_CODE).getAsString() : "NA");
            sql.setObject(6, this.getTags(properties));
            sql.setString(7, properties.get("itemType").getAsString());
            sql.setObject(8, this.timestamp);
            sql.addBatch();
        }
        catch (SQLException error) {
            logger.error("Unable to create Flag {} SQL statement", (Object)flag.getIdentifier());
        }
    }

    public void createDatabaseSchema(Connection connection, String schemaName) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(DatabaseConnection.class.getResourceAsStream("schema.sql")));
        LineNumberReader lnReader = new LineNumberReader(reader);
        try (Statement sql = connection.createStatement();){
            String query = ScriptUtils.readScript((LineNumberReader)lnReader, (String)"--", (String)";").replace("{schema}", schemaName);
            sql.execute(query);
            logger.info("Successfully created database schema.");
        }
        catch (IOException error) {
            throw new CoreException("Error reading schema.sql", (Throwable)error);
        }
        catch (SQLException error) {
            throw new CoreException("Error executing create schema script.", (Throwable)error);
        }
    }

    public int execute() {
        Time timer = Time.now();
        try (DatabaseConnection database = new DatabaseConnection((String)this.optionAndArgumentDelegate.getOptionArgument(DATABASE_URL_INPUT).get());
             Connection databaseConnection = database.getConnection();){
            String inputPath = (String)this.optionAndArgumentDelegate.getOptionArgument(FLAG_PATH_INPUT).get();
            this.timestamp = new Timestamp(Instant.now().toEpochMilli());
            this.createDatabaseSchema(databaseConnection, database.getSchema());
            new File(inputPath).listFilesRecursively().forEach(file -> {
                Optional<FileUtility.LogOutputFileType> optionalHandledFileType = FileUtility.getOptionalLogOutputType(file);
                optionalHandledFileType.ifPresent(logOutputFileType -> {
                    try (BufferedReader reader = FileUtility.getReader(file, logOutputFileType);
                         PreparedStatement flagSqlStatement = databaseConnection.prepareStatement(CREATE_FLAG_SQL, 1);
                         PreparedStatement featureSqlStatement = databaseConnection.prepareStatement(CREATE_FEATURE_SQL);){
                        List<String> lines = reader.lines().collect(Collectors.toList());
                        this.processCheckFlags(lines, flagSqlStatement, featureSqlStatement);
                    }
                    catch (IOException error) {
                        logger.error("Exception while reading {}:", file, (Object)error);
                    }
                    catch (SQLException error) {
                        logger.error("Exception batch executing flag statements", (Throwable)error);
                    }
                });
            });
        }
        catch (SQLException error) {
            logger.error("Invalid connection string. host[:port]/database", (Throwable)error);
            return 1;
        }
        logger.info("Atlas Checks database upload command finished in {}.", (Object)timer.elapsedSince());
        return 0;
    }

    public void executeFlagStatement(PreparedStatement sql, CheckFlag flag) {
        try {
            sql.setString(1, flag.getIdentifier());
            sql.setString(2, flag.getChallengeName().orElse(""));
            sql.setString(3, flag.getInstructions().replace("\n", " ").replace("'", "''"));
            sql.setString(4, this.optionAndArgumentDelegate.getOptionArgument(RUN_URI_INPUT).orElse(""));
            sql.setString(5, this.optionAndArgumentDelegate.getOptionArgument(SOFTWARE_VERSION_INPUT).orElse(""));
            sql.setObject(6, this.timestamp);
            sql.executeUpdate();
        }
        catch (SQLException error) {
            logger.error("Unable to create Flag {} SQL statement", (Object)flag.getIdentifier(), (Object)error);
        }
    }

    public String getCommandName() {
        return "flag-database";
    }

    public long getOsmIdentifier(JsonObject properties) {
        return properties.get(OSM_ID_LEGACY) == null ? properties.get("osmIdentifier").getAsLong() : properties.get(OSM_ID_LEGACY).getAsLong();
    }

    public String getSimpleDescription() {
        return "Upload Atlas Checks flags into a Postgres database";
    }

    public Map<String, String> getTags(JsonObject properties) {
        HashMap<String, String> hstore = new HashMap<String, String>();
        properties.entrySet().stream().filter(key -> !blacklistKeys.contains(key.getKey())).map(Map.Entry::getKey).forEach(key -> hstore.put((String)key, properties.get(key).getAsString()));
        return hstore;
    }

    public void processCheckFlags(List<String> lines, PreparedStatement flagSqlStatement, PreparedStatement featureSqlStatement) {
        int counter = 0;
        try {
            for (String line : lines) {
                JsonObject parsedFlag = new JsonParser().parse(line).getAsJsonObject();
                JsonArray features = this.filterOutPointsFromGeojson(parsedFlag.get("features").getAsJsonArray());
                CheckFlag flag = (CheckFlag)gson.fromJson(line, CheckFlag.class);
                if (counter + features.size() > 1000) {
                    featureSqlStatement.executeBatch();
                    logger.debug("Batching {} features.", (Object)counter);
                    counter = 0;
                }
                this.executeFlagStatement(flagSqlStatement, flag);
                ResultSet resultSet = flagSqlStatement.getGeneratedKeys();
                try {
                    if (resultSet == null || !resultSet.next()) continue;
                    int flagRecordId = resultSet.getInt(1);
                    StreamSupport.stream(features.spliterator(), false).forEach(feature -> this.batchFlagFeatureStatement(featureSqlStatement, flag, flagRecordId, feature.getAsJsonObject()));
                    counter += features.size();
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
            featureSqlStatement.executeBatch();
            logger.debug("Batching the remaining {} features.", (Object)counter);
        }
        catch (SQLException failure) {
            logger.error("Error creating Flag record.", (Throwable)failure);
        }
    }

    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", FlagDatabaseSubCommand.class.getResourceAsStream("FlagDatabaseSubCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", FlagDatabaseSubCommand.class.getResourceAsStream("FlagDatabaseSubCommandExamplesSection.txt"));
    }

    public void registerOptionsAndArguments() {
        this.registerOptionWithRequiredArgument(FLAG_PATH_INPUT, Character.valueOf('f'), "A directory of folders containing atlas-checks log files.", OptionOptionality.REQUIRED, FLAG_PATH_INPUT, new Integer[0]);
        this.registerOptionWithRequiredArgument(DATABASE_URL_INPUT, Character.valueOf('t'), "Database connection string", OptionOptionality.REQUIRED, DATABASE_URL_INPUT, new Integer[0]);
        this.registerOptionWithRequiredArgument(RUN_URI_INPUT, Character.valueOf('u'), "Flag generation URI", OptionOptionality.OPTIONAL, RUN_URI_INPUT, new Integer[0]);
        this.registerOptionWithRequiredArgument(SOFTWARE_VERSION_INPUT, Character.valueOf('v'), "Version of the software that generated the flags.", OptionOptionality.OPTIONAL, SOFTWARE_VERSION_INPUT, new Integer[0]);
        super.registerOptionsAndArguments();
    }

    private JsonArray filterOutPointsFromGeojson(JsonArray features) {
        return StreamSupport.stream(features.spliterator(), false).map(JsonElement::getAsJsonObject).filter(feature -> feature.has("properties") && !feature.get("properties").getAsJsonObject().entrySet().isEmpty()).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }

    static {
        blacklistKeys.add("itemType");
        blacklistKeys.add("identifier");
        blacklistKeys.add(OSM_ID_LEGACY);
        blacklistKeys.add("osmIdentifier");
        blacklistKeys.add("relations");
        blacklistKeys.add("members");
        blacklistKeys.add(ISO_COUNTRY_CODE);
    }
}

