/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.atlas.checks.commands.JSONFlagDiffSubCommand;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasChecksLogDiffSubCommand
extends JSONFlagDiffSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasChecksLogDiffSubCommand.class);

    public AtlasChecksLogDiffSubCommand() {
        super("log-diff", "Takes 2 sets of atlas-checks log flag files and reports the number of additions, subtractions, and changed flags from reference to input.", "log");
    }

    @Override
    protected Map<String, Map<Set<String>, JsonObject>> mapFeatures(File file) {
        HashMap<String, Map<Set<String>, JsonObject>> checkFeatureMap = new HashMap<String, Map<Set<String>, JsonObject>>();
        try (InputStreamReader inputStreamReader = file.isGzipped() ? new InputStreamReader(new GZIPInputStream(new FileInputStream(file.getFile()))) : new FileReader(file.getPath());
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                JsonObject source = (JsonObject)this.getGson().fromJson(line, JsonObject.class);
                String checkName = source.get("properties").getAsJsonObject().get("generator").getAsString();
                checkFeatureMap.putIfAbsent(checkName, new HashMap());
                ((Map)checkFeatureMap.get(checkName)).put(this.getAtlasIdentifiers(source.get("features").getAsJsonArray()), source);
            }
        }
        catch (IOException exception) {
            logger.warn("File read failed with exception", (Throwable)exception);
        }
        return checkFeatureMap;
    }

    private Set<String> getAtlasIdentifiers(JsonArray features) {
        return Iterables.stream((Iterable)features).filter(object -> object.getAsJsonObject().get("properties").getAsJsonObject().has("identifier")).map(object -> object.getAsJsonObject().get("properties").getAsJsonObject().get("identifier").getAsString()).collectToSet();
    }
}

