/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.EdgeWalker;
import org.openstreetmap.atlas.utilities.scalars.Distance;

class RoadNameSpellingConsistencyCheckWalker
extends EdgeWalker {
    private static final String ALPHANUMERIC_IDENTIFIER_STRING_REGEX = ".*\\p{Nd}+.*";
    private static final String CHARACTER_IDENTIFIER_STRING_REGEX = "\\p{P}.\\p{P}|.\\p{P}|\\p{P}.|^.$";
    private static final String WHITESPACE_REGEX = "\\s+";

    static Predicate<Edge> isEdgeWithInconsistentSpelling(Edge startEdge) {
        return incomingEdge -> {
            if (!incomingEdge.getName().isPresent()) {
                return false;
            }
            String startEdgeName = (String)startEdge.getName().get();
            String incomingEdgeName = (String)incomingEdge.getName().get();
            return RoadNameSpellingConsistencyCheckWalker.similarLengthDifferentCharacters(incomingEdgeName, startEdgeName) && RoadNameSpellingConsistencyCheckWalker.identifierSubstringsAreEqual(incomingEdgeName, startEdgeName) && RoadNameSpellingConsistencyCheckWalker.editDistanceIsOne(incomingEdgeName, startEdgeName);
        };
    }

    private static Function<Edge, Stream<Edge>> edgesWithinMaximumSearchDistance(Edge startEdge, Distance maximumSearchDistance) {
        return incomingEdge -> incomingEdge.end().getLocation().distanceTo(startEdge.start().getLocation()).isLessThanOrEqualTo(maximumSearchDistance) ? incomingEdge.connectedEdges().stream().filter(Edge::isMasterEdge) : Stream.empty();
    }

    private static boolean editDistanceIsOne(String incomingEdgeName, String startingEdgeName) {
        int editDistance = 0;
        if (incomingEdgeName.length() == startingEdgeName.length()) {
            for (int index = 0; index < incomingEdgeName.length(); ++index) {
                if (incomingEdgeName.charAt(index) == startingEdgeName.charAt(index) || ++editDistance <= 1) continue;
                return false;
            }
        } else {
            boolean incomingEdgeNameIsLonger = incomingEdgeName.length() > startingEdgeName.length();
            int endIndex = incomingEdgeNameIsLonger ? startingEdgeName.length() : incomingEdgeName.length();
            int incomingEdgePointer = 0;
            for (int startingEdgePointer = 0; startingEdgePointer < endIndex; ++startingEdgePointer) {
                if (incomingEdgeName.charAt(incomingEdgePointer) != startingEdgeName.charAt(startingEdgePointer)) {
                    if (++editDistance > 1) {
                        return false;
                    }
                    if (incomingEdgeNameIsLonger) {
                        ++incomingEdgePointer;
                    } else {
                        ++startingEdgePointer;
                    }
                    if (incomingEdgeName.charAt(incomingEdgePointer) != startingEdgeName.charAt(startingEdgePointer)) {
                        return false;
                    }
                }
                ++incomingEdgePointer;
            }
        }
        return true;
    }

    private static boolean identifierSubstringsAreEqual(String incomingEdgeName, String startingEdgeName) {
        List incomingEdgeNameAlphanumericIdentifierStrings = Arrays.stream(incomingEdgeName.split(WHITESPACE_REGEX)).filter(substring -> substring.matches(ALPHANUMERIC_IDENTIFIER_STRING_REGEX) || substring.matches(CHARACTER_IDENTIFIER_STRING_REGEX) || Stream.of(CJKNumbers.values()).anyMatch(cjkNumber -> substring.contains(new String(Character.toChars(cjkNumber.getValue()))))).collect(Collectors.toList());
        List startingEdgeNameAlphanumericIdentifierStrings = Arrays.stream(startingEdgeName.split(WHITESPACE_REGEX)).filter(substring -> substring.matches(ALPHANUMERIC_IDENTIFIER_STRING_REGEX) || substring.matches(CHARACTER_IDENTIFIER_STRING_REGEX) || Stream.of(CJKNumbers.values()).anyMatch(cjkNumber -> substring.contains(new String(Character.toChars(cjkNumber.getValue()))))).collect(Collectors.toList());
        long incomingEdgeNameIdentifierCount = incomingEdgeNameAlphanumericIdentifierStrings.size();
        long startingEdgeNameIdentifierCount = startingEdgeNameAlphanumericIdentifierStrings.size();
        long combinedIdentifierCount = Stream.concat(incomingEdgeNameAlphanumericIdentifierStrings.stream(), startingEdgeNameAlphanumericIdentifierStrings.stream()).distinct().count();
        return combinedIdentifierCount <= incomingEdgeNameIdentifierCount && combinedIdentifierCount <= startingEdgeNameIdentifierCount;
    }

    private static boolean similarLengthDifferentCharacters(String incomingEdgeName, String startEdgeName) {
        return !incomingEdgeName.equals(startEdgeName) && Math.abs(incomingEdgeName.length() - startEdgeName.length()) <= 1;
    }

    RoadNameSpellingConsistencyCheckWalker(Edge startEdge, Distance maximumSearchDistance) {
        super(startEdge, RoadNameSpellingConsistencyCheckWalker.edgesWithinMaximumSearchDistance(startEdge, maximumSearchDistance));
    }

    static enum CJKNumbers {
        CJK_ZERO(12295),
        CJK_ONE(19968),
        CJK_TWO(20108),
        CJK_THREE(19977),
        CJK_FOUR(22235),
        CJK_FIVE(20116),
        CJK_SIX(20845),
        CJK_SEVEN(19971),
        CJK_EIGHT(20843),
        CJK_NINE(20061),
        CJK_TEN(21313),
        CJK_TWENTY(24319),
        CJK_THIRTY(21317);

        private final int value;

        private CJKNumbers(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

