/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.NameTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class MixedCaseNameCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 7109483897229499466L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("{0} {1,number,#} has (an) invalid mixed-case value(s) for the following tag(s): {2}.");
    private static final List<String> CHECK_NAME_COUNTRIES_DEFAULT = Arrays.asList("AIA", "ATG", "AUS", "BHS", "BRB", "BLZ", "BMU", "BWA", "VGB", "CMR", "CAN", "CYM", "DMA", "FJI", "GMB", "GHA", "GIB", "GRD", "GUY", "IRL", "JAM", "KEN", "LSO", "MWI", "MLT", "MUS", "MSR", "NAM", "NZL", "NGA", "PNG", "SYC", "SLE", "SGP", "SLB", "ZAF", "SWZ", "TZA", "TON", "TTO", "TCA", "UGA", "GBR", "USA", "VUT", "ZMB", "ZWE");
    private static final List<String> LANGUAGE_NAME_TAGS_DEFAULT = Arrays.asList("name:en");
    private static final List<String> LOWER_CASE_PREPOSITIONS_DEFAULT = Arrays.asList("and", "from", "to", "of", "by", "upon", "on", "off", "at", "as", "into", "like", "near", "onto", "per", "till", "up", "via", "with", "for", "in");
    private static final List<String> LOWER_CASE_ARTICLES_DEFAULT = Arrays.asList("a", "an", "the");
    private static final String SPLIT_CHARACTERS_DEFAULT = " -/&@\u2013";
    private static final List<String> NAME_AFFIXES_DEFAULT = Arrays.asList("Mc", "Mac", "Mck", "Mhic", "Mic");
    private static final List<String> MIXED_CASE_UNITS_DEFAULT = Arrays.asList("kV");
    private final List<String> checkNameCountries;
    private final List<String> languageNameTags;
    private final List<String> lowerCasePrepositions;
    private final List<String> lowerCaseArticles;
    private final String splitCharacters;
    private final String nameAffixes;
    private final String mixedCaseUnits;
    private final Pattern upperCasePattern;
    private final Pattern anyLetterPattern;
    private final Pattern lowerCasePattern;
    private final Pattern mixedCaseUnitsPattern;
    private final Pattern mixedCaseApostrophePattern;
    private final Pattern nonFirstCapitalPattern;

    public MixedCaseNameCheck(Configuration configuration) {
        super(configuration);
        this.checkNameCountries = this.configurationValue(configuration, "check_name.countries", CHECK_NAME_COUNTRIES_DEFAULT);
        this.languageNameTags = this.configurationValue(configuration, "name.language.keys", LANGUAGE_NAME_TAGS_DEFAULT);
        this.lowerCasePrepositions = this.configurationValue(configuration, "name.prepositions", LOWER_CASE_PREPOSITIONS_DEFAULT);
        this.lowerCaseArticles = this.configurationValue(configuration, "name.articles", LOWER_CASE_ARTICLES_DEFAULT);
        this.splitCharacters = this.configurationValue(configuration, "regex.split", SPLIT_CHARACTERS_DEFAULT);
        this.nameAffixes = this.configurationValue(configuration, "name.affixes", NAME_AFFIXES_DEFAULT, value -> String.join((CharSequence)"|", value));
        this.mixedCaseUnits = this.configurationValue(configuration, "name.units", MIXED_CASE_UNITS_DEFAULT, value -> String.join((CharSequence)"|", value));
        this.upperCasePattern = Pattern.compile("\\p{Lu}");
        this.anyLetterPattern = Pattern.compile("\\p{L}");
        this.lowerCasePattern = Pattern.compile("\\p{Ll}");
        this.mixedCaseUnitsPattern = Pattern.compile(String.format("[^\\p{L}]*\\p{Digit}[%1$s][^\\p{L}]*", this.mixedCaseUnits));
        this.mixedCaseApostrophePattern = Pattern.compile("([^\\p{Ll}]+'\\p{Ll})|([^\\p{Ll}]+\\p{Ll}')");
        this.nonFirstCapitalPattern = Pattern.compile(String.format("(\\p{L}.*(?<!'|%1$s)(\\p{Lu}))|(\\p{L}.*(?<=')\\p{Lu}(?!.))", this.nameAffixes));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !(object instanceof Relation) && !this.isFlagged(object.getOsmIdentifier()) && (object.getTags().containsKey("iso_country_code") && this.checkNameCountries.contains(object.tag("iso_country_code").toUpperCase()) && Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{NameTag.class}) || this.languageNameTags.stream().anyMatch(key -> object.getOsmTags().containsKey(key)));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        ArrayList<String> mixedCaseNameTags = new ArrayList<String>();
        Map osmTags = object.getOsmTags();
        String country = object.tag("iso_country_code");
        if (country != null && this.checkNameCountries.contains(country.toUpperCase()) && Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{NameTag.class}) && this.isMixedCase((String)osmTags.get("name"))) {
            mixedCaseNameTags.add("name");
        }
        for (String key : this.languageNameTags) {
            if (!osmTags.containsKey(key) || !this.isMixedCase((String)osmTags.get(key))) continue;
            mixedCaseNameTags.add(key);
        }
        if (!mixedCaseNameTags.isEmpty()) {
            this.markAsFlagged(object.getOsmIdentifier());
            String instruction = this.getLocalizedInstruction(0, object instanceof LocationItem ? "Node" : "Way", object.getOsmIdentifier(), String.join((CharSequence)", ", mixedCaseNameTags));
            if (object instanceof Edge) {
                return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction));
            }
            return Optional.of(this.createFlag(object, instruction));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isMixedCase(String value) {
        if (this.upperCasePattern.matcher(value).find()) {
            String[] wordArray = value.split("[\\Q" + this.splitCharacters + "\\E]");
            boolean firstWord = true;
            for (String word : wordArray) {
                if (!this.isMixedCaseUnit(word)) {
                    Matcher firstLetterMatcher = this.anyLetterPattern.matcher(word);
                    if (!this.lowerCasePrepositions.contains(word) && (firstWord || !this.lowerCaseArticles.contains(word)) && firstLetterMatcher.find() && Character.isLowerCase(firstLetterMatcher.group().charAt(0)) && (firstLetterMatcher.start() == 0 || !Character.isDigit(word.charAt(firstLetterMatcher.start() - 1))) || this.lowerCasePattern.matcher(word).find() && !this.isMixedCaseApostrophe(word) && this.isProperNonFirstCapital(word)) {
                        return true;
                    }
                }
                firstWord = false;
            }
        }
        return false;
    }

    private boolean isMixedCaseApostrophe(String word) {
        return this.mixedCaseApostrophePattern.matcher(word).matches();
    }

    private boolean isMixedCaseUnit(String word) {
        return this.mixedCaseUnitsPattern.matcher(word).find();
    }

    private boolean isProperNonFirstCapital(String word) {
        return this.nonFirstCapitalPattern.matcher(word).find();
    }
}

