/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class AddressPointMatchCheck
extends BaseCheck {
    public static final String NO_STREET_NAME_POINT_INSTRUCTIONS = "This Node, {0,number,#}, has no street name specified in the address. The street name should likely be one of {1}. These names were derived from nearby Nodes.";
    public static final String NO_STREET_NAME_EDGE_INSTRUCTIONS = "This Node, {0,number,#}, has no street name specified in the address. The street name should likely be one of {1}. These names were derived from nearby Ways.";
    public static final String NO_SUGGESTED_NAMES_INSTRUCTIONS = "This node, {0,number,#}, has no street name specified in the address. No suggestions names were found as there were no nearby Nodes or Ways with street name key tags.";
    private static final long serialVersionUID = -756695185133616997L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This Node, {0,number,#}, has no street name specified in the address. The street name should likely be one of {1}. These names were derived from nearby Nodes.", "This Node, {0,number,#}, has no street name specified in the address. The street name should likely be one of {1}. These names were derived from nearby Ways.", "This node, {0,number,#}, has no street name specified in the address. No suggestions names were found as there were no nearby Nodes or Ways with street name key tags.");
    private static final String STREET_RELATION_ROLE = "street";
    private static final double BOUNDS_SIZE_DEFAULT = 75.0;
    private final Distance boundsSize;

    public AddressPointMatchCheck(Configuration configuration) {
        super(configuration);
        this.boundsSize = Distance.meters((double)this.configurationValue(configuration, "bounds.size", 75.0));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Point && !this.hasAssociatedStreetRelation(object) && object.getTag("addr:housenumber").isPresent() && Strings.isNullOrEmpty((String)object.tag("addr:street"));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Point point = (Point)object;
        Rectangle box = point.getLocation().boxAround(this.boundsSize);
        Set points = Iterables.stream((Iterable)point.getAtlas().pointsWithin((GeometricSurface)box)).map(nearbyPoint -> nearbyPoint.tag("addr:street")).filter(Objects::nonNull).collectToSet();
        Set edges = Iterables.stream((Iterable)point.getAtlas().edgesIntersecting((GeometricSurface)box)).map(nearbyEdge -> nearbyEdge.tag("name")).filter(Objects::nonNull).collectToSet();
        if (points.isEmpty() && edges.isEmpty()) {
            return Optional.of(this.createFlag((AtlasObject)point, this.getLocalizedInstruction(2, point.getOsmIdentifier())));
        }
        if (!points.isEmpty()) {
            return Optional.of(this.createFlag((AtlasObject)point, this.getLocalizedInstruction(0, point.getOsmIdentifier(), points)));
        }
        return Optional.of(this.createFlag((AtlasObject)point, this.getLocalizedInstruction(1, point.getOsmIdentifier(), edges)));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean hasAssociatedStreetRelation(AtlasObject object) {
        Point point = (Point)object;
        return point.relations().stream().filter(relation -> Validators.isOfType((Taggable)relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ASSOCIATEDSTREET})).anyMatch(relation -> relation.members().stream().anyMatch(member -> member.getRole().equals(STREET_RELATION_ROLE) && member.getEntity().getType().equals((Object)ItemType.EDGE)));
    }
}

