/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class InconsistentRoadClassificationCheck
extends BaseCheck<Long> {
    private static final String CHANGE_BACK_INSTRUCTION = "Way {0,number,#} goes back to {1} and creates inconsistency.";
    private static final String MINIMUM_HIGHWAY_TYPE_DEFAULT = HighwayTag.TERTIARY_LINK.toString();
    private static final double SIMILAR_DIRECTION_DIFFERENCE_THRESHOLD_DEFAULT = 30.0;
    private static final double MAXIMUM_EDGE_LENGTH_DEFAULT = 200.0;
    private static final double LONG_EDGE_THRESHOLD = 1000.0;
    private static final String STARTS_OFF_INSTRUCTION = "Road classification inconsistency exists. Way {0,number,#} starts off as {1}.";
    private static final String WAY_ID_AS_INSTRUCTION = "Way {0,number,#} is identified as {1}.";
    private static final String CURVED_ROAD_INSTRUCTION = "If this edge is part of a curved road, then this flag might not require edits or the road classification needs to be modified";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Road classification inconsistency exists. Way {0,number,#} starts off as {1}.", "Way {0,number,#} is identified as {1}.", "Way {0,number,#} goes back to {1} and creates inconsistency.", "If this edge is part of a curved road, then this flag might not require edits or the road classification needs to be modified");
    private static final int CURVED_ROAD_INSTR_IDX = 3;
    private static final int TWO_CONNECTED_EDGES = 2;
    private static final long serialVersionUID = -7507140896133909501L;
    private final HighwayTag minimumHighwayType;
    private final Distance maximumEdgeLength;
    private final Angle similarDirectionDifferenceThreshold;
    private final Distance longEdgeThreshold;

    public InconsistentRoadClassificationCheck(Configuration configuration) {
        super(configuration);
        String highwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_TYPE_DEFAULT);
        this.minimumHighwayType = Enum.valueOf(HighwayTag.class, highwayType.toUpperCase());
        this.maximumEdgeLength = Distance.meters((double)this.configurationValue(configuration, "maximum.edge.length", 200.0));
        this.similarDirectionDifferenceThreshold = this.configurationValue(configuration, "maximum.direction.change.degrees", 30.0, Angle::degrees);
        this.longEdgeThreshold = this.configurationValue(configuration, "long.edge.threshold", 1000.0, Distance::meters);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        if (object instanceof Edge && !this.isFlagged(object.getOsmIdentifier())) {
            Edge edge = (Edge)object;
            return edge.highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayType) && !edge.highwayTag().isLink() && !JunctionTag.isRoundabout((Taggable)edge) && edge.overallHeading().isPresent() && edge.outEdges().stream().noneMatch(connectedEdge -> edge.getMasterEdgeIdentifier() != connectedEdge.getMasterEdgeIdentifier() && edge.getOsmIdentifier() == connectedEdge.getOsmIdentifier());
        }
        return false;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject item) {
        Edge edge = (Edge)item;
        List<Tuple<Edge, Set<Edge>>> inconsistentEdgeTuples = this.findInconsistentEdges(edge);
        if (!inconsistentEdgeTuples.isEmpty()) {
            CheckFlag flag = this.createFlag(item, this.getLocalizedInstruction(0, edge.getOsmIdentifier(), edge.highwayTag()));
            this.markAsFlagged(edge.getOsmIdentifier());
            inconsistentEdgeTuples.forEach(inconsistentEdgeTuple -> {
                Edge inconsistentEdge = (Edge)inconsistentEdgeTuple.getFirst();
                Set inEdges = inconsistentEdge.inEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
                Set outEdges = inconsistentEdge.outEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
                Distance edgeLength = inconsistentEdge.asPolyLine().length();
                if (inEdges.size() <= 2 && outEdges.size() <= 2 || edgeLength.isLessThanOrEqualTo(this.maximumEdgeLength)) {
                    flag.addObject((AtlasObject)inconsistentEdge, this.getLocalizedInstruction(1, inconsistentEdge.getOsmIdentifier(), inconsistentEdge.highwayTag()));
                    flag.addPoints(Iterables.iterable((Object[])new Location[]{inconsistentEdge.start().getLocation(), inconsistentEdge.end().getLocation()}));
                    this.markAsFlagged(inconsistentEdge.getOsmIdentifier());
                    ((Set)inconsistentEdgeTuple.getSecond()).forEach(followingEdge -> {
                        flag.addObject((AtlasObject)followingEdge, this.getLocalizedInstruction(2, followingEdge.getOsmIdentifier(), followingEdge.highwayTag()));
                        this.markAsFlagged(followingEdge.getOsmIdentifier());
                    });
                    if (edgeLength.isLessThanOrEqualTo(this.maximumEdgeLength) && (inEdges.size() > 2 || outEdges.size() > 2)) {
                        flag.addObject((AtlasObject)inconsistentEdge, this.getLocalizedInstruction(3, new Object[0]));
                    }
                }
            });
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Predicate<Edge> allConnectedEdgesFilter(Edge referenceEdge, HighwayTag referenceHighwayType) {
        return connectedEdge -> referenceEdge.getIdentifier() != connectedEdge.getIdentifier() && !JunctionTag.isRoundabout((Taggable)connectedEdge) && connectedEdge.highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayType) && this.areInTheSimilarDirection(referenceEdge, (Edge)connectedEdge) && !referenceHighwayType.isOfEqualClassification(connectedEdge.highwayTag()) && !this.isContinuousOutgoingEdge((Edge)connectedEdge);
    }

    private boolean areInTheSimilarDirection(Edge edge, Edge anotherEdge) {
        List firstEdgeSegments = edge.asPolyLine().segments();
        Segment lastSegment = (Segment)firstEdgeSegments.get(firstEdgeSegments.size() - 1);
        Optional finalHeading = lastSegment.heading();
        Segment secondSegment = (Segment)anotherEdge.asPolyLine().segments().get(0);
        Optional initialHeading = secondSegment.heading();
        return finalHeading.isPresent() && initialHeading.isPresent() && ((Heading)finalHeading.get()).difference((Angle)initialHeading.get()).isLessThan(this.similarDirectionDifferenceThreshold);
    }

    private Stream<Edge> connectionsSimilarToReferenceEdge(HighwayTag referenceHighwayType, Edge edge) {
        return edge.outEdges().stream().filter(connectedEdge -> referenceHighwayType.isOfEqualClassification(connectedEdge.highwayTag()) && this.areInTheSimilarDirection(edge, (Edge)connectedEdge));
    }

    private List<Tuple<Edge, Set<Edge>>> findInconsistentEdges(Edge referenceEdge) {
        HighwayTag referenceHighwayType = referenceEdge.highwayTag();
        Map<Boolean, List<Edge>> edgesAreProblematicLinks = referenceEdge.outEdges().stream().filter(this.allConnectedEdgesFilter(referenceEdge, referenceHighwayType)).collect(Collectors.partitioningBy(edge -> this.isProblematicLink((Edge)edge, referenceHighwayType)));
        return Stream.concat(edgesAreProblematicLinks.get(true).stream().map(this.getSimilarEdgesTuple(referenceHighwayType, middleEdge -> endEdge -> true)), edgesAreProblematicLinks.get(false).stream().filter(this.nonLinkEdgesFilter(referenceHighwayType)).map(this.getSimilarEdgesTuple(referenceHighwayType, middleEdge -> endEdge -> !this.loopsBackOnSelf(referenceEdge, (Edge)middleEdge, (Edge)endEdge)))).flatMap(result -> result.isPresent() ? Stream.of((Tuple)result.get()) : Stream.empty()).collect(Collectors.toList());
    }

    private Function<Edge, Optional<Tuple<Edge, Set<Edge>>>> getSimilarEdgesTuple(HighwayTag referenceHighwayType, Function<Edge, Predicate<Edge>> tuplesFilter) {
        return connectedEdge -> {
            Set inEdges = connectedEdge.inEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
            Set outEdges = connectedEdge.outEdges().stream().filter(Edge::isMasterEdge).collect(Collectors.toSet());
            Set similarConnections = this.connectionsSimilarToReferenceEdge(referenceHighwayType, (Edge)connectedEdge).filter((Predicate)tuplesFilter.apply((Edge)connectedEdge)).collect(Collectors.toSet());
            if (!similarConnections.isEmpty() && (inEdges.size() <= 2 && outEdges.size() <= 2 || connectedEdge.asPolyLine().length().isLessThanOrEqualTo(this.maximumEdgeLength))) {
                return Optional.of(Tuple.createTuple((Object)connectedEdge, similarConnections));
            }
            return Optional.empty();
        };
    }

    private boolean isBypassed(Edge inconsistency, HighwayTag referenceHighwayTag) {
        return inconsistency.start().outEdges().stream().anyMatch(edge -> !edge.equals((Object)inconsistency) && edge.end().equals((Object)inconsistency.end()) && edge.highwayTag().isIdenticalClassification(referenceHighwayTag));
    }

    private boolean isContinuousOutgoingEdge(Edge edge) {
        return edge.outEdges().stream().anyMatch(connectedEdge -> edge.highwayTag().isOfEqualClassification(connectedEdge.highwayTag()) && this.areInTheSimilarDirection(edge, (Edge)connectedEdge));
    }

    private boolean isLongLessImportantEdge(Edge connectedEdge, HighwayTag referenceHighwayType) {
        return referenceHighwayType.isMoreImportantThan(connectedEdge.highwayTag()) && connectedEdge.length().isGreaterThanOrEqualTo(this.longEdgeThreshold);
    }

    private boolean isPartOfALongerRoad(Edge edge, HighwayTag referenceHighwayType) {
        return edge.highwayTag().isMoreImportantThan(referenceHighwayType) && (edge.length().isGreaterThanOrEqualTo(this.longEdgeThreshold) || edge.connectedNodes().stream().allMatch(node -> node.connectedEdges().stream().anyMatch(connectedEdge -> edge.getMasterEdgeIdentifier() != connectedEdge.getMasterEdgeIdentifier() && edge.highwayTag().isOfEqualClassification(connectedEdge.highwayTag()))));
    }

    private boolean isProblematicLink(Edge inconsistency, HighwayTag referenceTag) {
        return inconsistency.highwayTag().isLink() && !referenceTag.isLink();
    }

    private boolean loopsBackOnSelf(Edge start, Edge inconsistent, Edge end) {
        return start.connectedNodes().stream().anyMatch(node -> inconsistent.connectedNodes().contains(node) && end.connectedNodes().contains(node));
    }

    private Predicate<Edge> nonLinkEdgesFilter(HighwayTag referenceHighwayType) {
        return edge -> !this.isPartOfALongerRoad((Edge)edge, referenceHighwayType) && !this.isBypassed((Edge)edge, referenceHighwayType) && !this.isLongLessImportantEdge((Edge)edge, referenceHighwayType);
    }
}

