/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengeDifficulty;
import org.openstreetmap.atlas.streaming.resource.ClassResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;

public class Survey
extends Challenge {
    public static final String KEY_ANSWERS = "answers";
    public static final String KEY_CHALLENGE = "challenge";
    private final List<String> answers;

    public static Challenge fromResource(String checkName) {
        ClassResource challenge = new ClassResource(checkName + FileSuffix.JSON.toString());
        return (Challenge)challenge.getJSONResourceObject(Survey.class);
    }

    public Survey(String name, String description, String blurb, String instruction, ChallengeDifficulty difficulty, List<String> answers, String tags) {
        super(name, description, blurb, instruction, difficulty, tags);
        this.answers = answers;
    }

    public List<String> getAnswers() {
        return this.answers;
    }

    @Override
    public JsonObject toJson(String challengeName) {
        JsonObject challengeJson = super.toJson(challengeName);
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        JsonObject surveyJson = (JsonObject)gson.fromJson("{}", JsonObject.class);
        surveyJson.add(KEY_CHALLENGE, (JsonElement)challengeJson);
        surveyJson.add(KEY_ANSWERS, gson.toJsonTree(this.answers));
        return surveyJson;
    }
}

