/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonObject;
import java.util.Map;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.geojson.GeoJsonUtils;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

public class FlaggedRelation
extends FlaggedObject {
    private static final long serialVersionUID = 81887932468503688L;
    private final Relation relation;
    private final Map<String, String> properties;
    private final String country;

    public FlaggedRelation(Relation relation) {
        this.relation = relation;
        this.properties = this.initProperties(relation);
        this.country = this.initCountry((AtlasObject)relation);
    }

    @Override
    public JsonObject asGeoJsonFeature(String flagIdentifier) {
        JsonObject geoJsonGeometry = this.relation.asGeoJsonGeometry();
        JsonObject featureProperties = this.relation.getGeoJsonProperties();
        featureProperties.addProperty("flag:id", flagIdentifier);
        featureProperties.addProperty("flag:type", FlaggedRelation.class.getSimpleName());
        return GeoJsonUtils.feature((JsonObject)geoJsonGeometry, (JsonObject)featureProperties);
    }

    public Rectangle bounds() {
        return this.relation.bounds();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isMultipolygonRelation() {
        return Validators.isOfType((Taggable)this.relation, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON});
    }

    public RelationMemberList members() {
        return this.relation.members();
    }

    private String initCountry(AtlasObject object) {
        Map tags = object.getTags();
        if (tags.containsKey("iso_country_code")) {
            return (String)tags.get("iso_country_code");
        }
        return "N/A";
    }

    private Map<String, String> initProperties(Relation relation) {
        Map tags = relation.getTags();
        tags.put("identifier", relation.getIdentifier() + "");
        tags.put("osmIdentifier", relation.getOsmIdentifier() + "");
        tags.put("itemType", "Relation");
        return tags;
    }
}

