/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.event;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openstreetmap.atlas.checks.distributed.GeoJsonPathFilter;
import org.openstreetmap.atlas.checks.event.CheckFlagEvent;
import org.openstreetmap.atlas.checks.event.Processor;
import org.openstreetmap.atlas.checks.event.ShutdownEvent;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckFlagGeoJsonProcessor
implements Processor<CheckFlagEvent> {
    private static final int MAX_BATCH_SUM = 25000;
    private static final int MIN_BATCH_SIZE = 100;
    private static final int BUCKET_CAPACITY = 100;
    private static final int BUCKET_INCREMENT = 25;
    private static final Logger logger = LoggerFactory.getLogger(CheckFlagGeoJsonProcessor.class);
    private final SparkFileHelper fileHelper;
    private final String directory;
    private final ConcurrentHashMap<String, Vector<JsonObject>> featureBuckets = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ReadWriteLock> bucketLocks = new ConcurrentHashMap();
    private boolean compressOutput = true;
    private int batchSizeOverride;
    private boolean hasWritten;

    public CheckFlagGeoJsonProcessor(SparkFileHelper fileHelper, String outputFolder) {
        this.fileHelper = fileHelper;
        this.directory = outputFolder;
        this.hasWritten = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void process(CheckFlagEvent event) {
        String challenge = event.getCheckFlag().getChallengeName().orElse(event.getCheckName());
        Vector featureBucket = this.featureBuckets.computeIfAbsent(challenge, key -> new Vector(100, 25));
        ReadWriteLock bucketLock = this.bucketLocks.computeIfAbsent(challenge, key -> new ReentrantReadWriteLock());
        bucketLock.readLock().lock();
        try {
            featureBucket.add(event.toGeoJsonFeature());
        }
        finally {
            bucketLock.readLock().unlock();
        }
        int batchSize = this.computeBatchSize();
        if (featureBucket.size() >= batchSize) {
            bucketLock.writeLock().lock();
            try {
                if (featureBucket.size() >= batchSize) {
                    this.write(challenge, featureBucket);
                }
            }
            finally {
                bucketLock.writeLock().unlock();
            }
        }
    }

    @Override
    @Subscribe
    public void process(ShutdownEvent event) {
        try {
            if (!this.featureBuckets.isEmpty()) {
                this.featureBuckets.forEach(this::write);
            } else {
                this.write("", new Vector<JsonObject>());
            }
        }
        catch (Exception e) {
            logger.warn("CheckFlag geojson file write is failed.", (Throwable)e);
        }
    }

    public CheckFlagGeoJsonProcessor withBatchSizeOverride(int batchSizeOverride) {
        this.batchSizeOverride = batchSizeOverride;
        return this;
    }

    public CheckFlagGeoJsonProcessor withCompression(boolean compress) {
        this.compressOutput = compress;
        return this;
    }

    protected int computeBatchSize() {
        if (this.batchSizeOverride > 0) {
            return this.batchSizeOverride;
        }
        if (this.featureBuckets.isEmpty()) {
            return 25000;
        }
        return Math.max(25000 / this.featureBuckets.size(), 100);
    }

    protected String getFilename(String challenge, int size) {
        return String.format("%s-%s-%s%s", challenge, new Date().getTime(), size, new GeoJsonPathFilter(this.compressOutput).getExtension());
    }

    private void write(String challenge, Vector<JsonObject> featureBucket) {
        if (featureBucket.size() > 0) {
            JsonObject featureCollection = new JsonObject();
            featureCollection.addProperty("type", "FeatureCollection");
            JsonArray featureJsonArray = new JsonArray();
            featureBucket.forEach(arg_0 -> ((JsonArray)featureJsonArray).add(arg_0));
            featureCollection.add("features", (JsonElement)featureJsonArray);
            this.fileHelper.write(this.directory, this.getFilename(challenge, featureJsonArray.size()), featureCollection.toString());
            this.hasWritten = true;
            featureBucket.clear();
        } else if (!this.hasWritten) {
            logger.warn("Writing empty file with no content in {}.", (Object)this.directory);
            this.fileHelper.write(this.directory, String.format("%s%s", "empty", new GeoJsonPathFilter(this.compressOutput).getExtension()), "");
        }
    }
}

