/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;

public class LogFilePathFilter
implements PathFilter {
    private static final String UNCOMPRESSED_FILE_EXTENSION = ".log";
    private static final String COMPRESSED_FILE_EXTENSION = ".log" + FileSuffix.GZIP.toString();
    private final String extension;

    public LogFilePathFilter() {
        this(true);
    }

    public LogFilePathFilter(boolean compressed) {
        this.extension = compressed ? COMPRESSED_FILE_EXTENSION : UNCOMPRESSED_FILE_EXTENSION;
    }

    public boolean accept(Path path) {
        return path.getName().endsWith(this.extension);
    }

    public String getExtension() {
        return this.extension;
    }
}

