/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.DirectionTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class InvalidMiniRoundaboutCheck
extends BaseCheck<Long> {
    private static final long DEFAULT_MINIMUM_VALENCE = 6L;
    private static final String MINIMUM_VALENCE_KEY = "valence.minimum";
    private static final String OTHER_EDGES_INSTRUCTION = "This Mini-Roundabout Node ({0,number,#}) has {1, number,#} connecting car-navigable Ways. Please verify that this is the most accurate tag. Possible alternate tags include, but are not limited to, traffic_calming=ISLAND, junction=CIRCULAR, or removing this tag entirely.";
    private static final String TWO_EDGES_INSTRUCTION = "This Mini-Roundabout Node ({0,number,#}) appears to be a turnaround. Consider changing this to highway=TURNING_LOOP or highway=TURNING_CIRCLE.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This Mini-Roundabout Node ({0,number,#}) appears to be a turnaround. Consider changing this to highway=TURNING_LOOP or highway=TURNING_CIRCLE.", "This Mini-Roundabout Node ({0,number,#}) has {1, number,#} connecting car-navigable Ways. Please verify that this is the most accurate tag. Possible alternate tags include, but are not limited to, traffic_calming=ISLAND, junction=CIRCULAR, or removing this tag entirely.");
    private static final DirectionTag[] VALID_DIRECTIONS = new DirectionTag[]{DirectionTag.CLOCKWISE, DirectionTag.ANTICLOCKWISE};
    private final long minimumValence;

    public InvalidMiniRoundaboutCheck(Configuration configuration) {
        super(configuration);
        this.minimumValence = this.configurationValue(configuration, MINIMUM_VALENCE_KEY, 6L);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Node && Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MINI_ROUNDABOUT});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Node node = (Node)object;
        Collection<Edge> carNavigableEdges = this.getCarNavigableEdges(node);
        long valence = carNavigableEdges.size();
        Optional<CheckFlag> result = Optional.empty();
        if (this.isTurnaround(carNavigableEdges)) {
            result = Optional.of(this.flagNode(node, carNavigableEdges, this.getLocalizedInstruction(0, node.getOsmIdentifier())));
        } else if (!Validators.isOfType((Taggable)node, DirectionTag.class, (Enum[])VALID_DIRECTIONS) && valence < this.minimumValence && valence > 0L) {
            result = Optional.of(this.flagNode(node, carNavigableEdges, this.getLocalizedInstruction(1, node.getOsmIdentifier(), this.getMasterEdgeCount(carNavigableEdges))));
        }
        return result;
    }

    private CheckFlag flagNode(Node node, Collection<Edge> edges, String instruction) {
        CheckFlag flag = this.createFlag((AtlasObject)node, instruction);
        edges.forEach(flag::addObject);
        return flag;
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isTurnaround(Collection<Edge> carNavigableEdges) {
        return this.getMasterEdgeCount(carNavigableEdges) == 1L && carNavigableEdges.size() == 2;
    }

    private Collection<Edge> getCarNavigableEdges(Node node) {
        return node.connectedEdges().stream().filter(HighwayTag::isCarNavigableHighway).collect(Collectors.toSet());
    }

    private long getMasterEdgeCount(Collection<Edge> carNavigableEdges) {
        return carNavigableEdges.stream().filter(Edge::isMasterEdge).count();
    }
}

