/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;

public class Task {
    protected static final String FEATURE = "Feature";
    protected static final String POINT = "Point";
    protected static final String TASK_FEATURES = "features";
    protected static final String TASK_FEATURE_COORDINATES = "coordinates";
    protected static final String TASK_FEATURE_GEOMETRY = "geometry";
    protected static final String TASK_FEATURE_PROPERTIES = "properties";
    protected static final String TASK_GEOMETRIES = "geometries";
    protected static final String TASK_INSTRUCTION = "instruction";
    protected static final String TASK_NAME = "name";
    protected static final String TASK_PARENT_ID = "parent";
    protected static final String TASK_TYPE = "type";
    private static final String KEY_DESCRIPTION = "description";
    private String challengeName;
    private Optional<JsonArray> geoJson = Optional.empty();
    private String instruction;
    private final Set<PointInformation> points = new HashSet<PointInformation>();
    private String projectName = "";
    private String taskIdentifier;

    public void addPoint(Location point, String description) {
        this.points.add(new PointInformation(point, Optional.ofNullable(description)));
    }

    public boolean equals(Object obj) {
        return obj instanceof Task && StringUtils.equals((CharSequence)this.taskIdentifier, (CharSequence)((Task)obj).getTaskIdentifier()) && StringUtils.equals((CharSequence)this.challengeName, (CharSequence)((Task)obj).getChallengeName());
    }

    public JsonObject generateTask(long parentIdentifier) {
        JsonObject task = new JsonObject();
        JsonObject result = new JsonObject();
        result.addProperty(TASK_TYPE, "FeatureCollection");
        result.add(TASK_FEATURES, (JsonElement)this.generateTaskFeatures(this.points, this.geoJson));
        task.add(TASK_INSTRUCTION, (JsonElement)new JsonPrimitive(this.instruction));
        task.add(TASK_NAME, (JsonElement)new JsonPrimitive(this.getTaskIdentifier()));
        task.add(TASK_PARENT_ID, (JsonElement)new JsonPrimitive((Number)parentIdentifier));
        task.add(TASK_GEOMETRIES, (JsonElement)result);
        return task;
    }

    public String getChallengeName() {
        return this.challengeName;
    }

    public Optional<JsonArray> getGeoJson() {
        return this.geoJson;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public Set<Location> getPoints() {
        return this.points.parallelStream().map(PointInformation::getLocation).collect(Collectors.toSet());
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public int hashCode() {
        return this.taskIdentifier.hashCode() + this.challengeName.hashCode();
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public void setGeoJson(Optional<JsonArray> geoJson) {
        this.geoJson = geoJson;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setPoint(Location point) {
        this.points.add(new PointInformation(point, Optional.empty()));
    }

    public void setPoints(Set<Location> points) {
        this.points.addAll(points.parallelStream().map(point -> new PointInformation((Location)point, Optional.empty())).collect(Collectors.toSet()));
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setTaskIdentifier(String taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    protected JsonArray generateTaskFeatures(Set<PointInformation> source, Optional<JsonArray> geoJson) {
        JsonArray features = new JsonArray();
        if (source.isEmpty() && !geoJson.isPresent()) {
            throw new CoreException("Could not find any features for the task [{}].", new Object[]{this.toString()});
        }
        source.forEach(point -> {
            JsonObject feature = new JsonObject();
            JsonObject geometry = new JsonObject();
            JsonArray coordinates = new JsonArray();
            coordinates.add((JsonElement)new JsonPrimitive((Number)point.getLocation().getLongitude().asDegrees()));
            coordinates.add((JsonElement)new JsonPrimitive((Number)point.getLocation().getLatitude().asDegrees()));
            geometry.add(TASK_TYPE, (JsonElement)new JsonPrimitive(POINT));
            geometry.add(TASK_FEATURE_COORDINATES, (JsonElement)coordinates);
            feature.add(TASK_FEATURE_GEOMETRY, (JsonElement)geometry);
            feature.add(TASK_TYPE, (JsonElement)new JsonPrimitive(FEATURE));
            JsonObject pointInformation = new JsonObject();
            point.getDescription().ifPresent(description -> pointInformation.add(KEY_DESCRIPTION, (JsonElement)new JsonPrimitive(description)));
            feature.add(TASK_FEATURE_PROPERTIES, (JsonElement)pointInformation);
            features.add((JsonElement)feature);
        });
        geoJson.ifPresent(json -> json.forEach(arg_0 -> ((JsonArray)features).add(arg_0)));
        return features;
    }

    private class PointInformation {
        private final Location location;
        private final Optional<String> description;

        PointInformation(Location location, Optional<String> description) {
            this.location = location;
            this.description = description;
        }

        public Optional<String> getDescription() {
            return this.description;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

