/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.distributed;

import org.apache.commons.lang.StringUtils;
import org.openstreetmap.atlas.checks.base.Check;
import org.openstreetmap.atlas.checks.event.EventService;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteClient;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunnableCheckBase<T extends Check> {
    private static final Logger logger = LoggerFactory.getLogger(RunnableCheckBase.class);
    private static final int MINIMUM_DURATION_SECONDS = 5;
    private static final int MINIMUM_DURATION_RATIO = 10;
    private final T check;
    private final Challenge challenge;
    private final String country;
    private final String name;
    private final MapRouletteClient client;
    private final Iterable<AtlasObject> objects;
    private final EventService eventService;

    private static Duration maxDurationForBatch(int batchSize) {
        return Duration.seconds((double)Math.max(5, batchSize / 10));
    }

    public RunnableCheckBase(String country, T check, Iterable<AtlasObject> objects, MapRouletteClient client) {
        this.country = country;
        this.check = check;
        this.challenge = check.getChallenge();
        this.name = this.check.getCheckName();
        if (StringUtils.isEmpty((String)this.challenge.getName())) {
            this.challenge.setName(this.name);
        }
        this.objects = objects;
        this.client = client;
        this.eventService = EventService.get(country);
    }

    public EventService getEventService() {
        return this.eventService;
    }

    protected void addTask(CheckFlag flag) {
        if (this.client != null) {
            try {
                this.client.addTask(this.check.getChallenge(), flag.getMapRouletteTask());
            }
            catch (Exception e) {
                logger.warn("Failed to create a MapRoulette task for [{}, {}]. Exception: {}.", new Object[]{this.name, flag, e});
            }
        }
    }

    protected T getCheck() {
        return this.check;
    }

    protected MapRouletteClient getClient() {
        return this.client;
    }

    protected String getCountry() {
        return this.country;
    }

    protected String getName() {
        return this.name;
    }

    protected Iterable<AtlasObject> getObjects() {
        return this.objects;
    }

    protected void uploadTasks() {
        if (this.client != null) {
            try (Pool uploadPool = new Pool(1, String.format("MR upload pool for %s (%s)", this.getName(), this.getCountry()), RunnableCheckBase.maxDurationForBatch(this.getClient().getCurrentBatchSize()));){
                uploadPool.queue(() -> this.getClient().uploadTasks());
            }
            catch (Exception e) {
                logger.error("Failed to upload tasks to MapRoulette client {}.", (Object)this.client, (Object)e);
            }
        } else {
            logger.trace("Ignoring upload to MapRoulette. Client was never initialized correctly. See beginning of log for more details.");
        }
    }
}

