/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.atlas.checks.commands.JSONFlagDiffSubCommand;
import org.openstreetmap.atlas.geography.geojson.GeoJsonType;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasChecksGeoJSONDiffSubCommand
extends JSONFlagDiffSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(AtlasChecksGeoJSONDiffSubCommand.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("([^ ]+) ?");

    public AtlasChecksGeoJSONDiffSubCommand() {
        super("geojson-diff", "Takes 2 sets of atlas-checks geoJSON flag files and reports the number of additions, subtractions, and changed flags from reference to input.", "geojson");
    }

    @Override
    protected Map<String, Map<Set<String>, JsonObject>> mapFeatures(File file) {
        HashMap<String, Map<Set<String>, JsonObject>> checkFeatureMap = new HashMap<String, Map<Set<String>, JsonObject>>();
        try (InputStream inputStream = file.isGzipped() ? new GZIPInputStream(new FileInputStream(file.getFile())) : file.read();){
            JsonObject json = (JsonObject)this.getGson().fromJson(new JsonReader((Reader)new InputStreamReader(inputStream)), JsonObject.class);
            json.get("features").getAsJsonArray().forEach(feature -> {
                JsonObject jsonFeature = feature.getAsJsonObject();
                Matcher nameMatch = NAME_PATTERN.matcher(jsonFeature.get("properties").getAsJsonObject().get("name").getAsString());
                nameMatch.find();
                String checkName = nameMatch.group(1);
                checkFeatureMap.putIfAbsent(checkName, new HashMap());
                ((Map)checkFeatureMap.get(checkName)).put(this.getAtlasIdentifiers(feature.getAsJsonObject().get("properties").getAsJsonObject().get("feature_properties").getAsJsonArray()), jsonFeature);
            });
        }
        catch (IOException exception) {
            logger.warn("File read failed with exception", (Throwable)exception);
        }
        return checkFeatureMap;
    }

    private Set<String> getAtlasIdentifiers(JsonArray properties) {
        return Iterables.stream((Iterable)properties).filter(object -> object.getAsJsonObject().has("identifier")).map(object -> object.getAsJsonObject().get("identifier").getAsString()).collectToSet();
    }

    @Override
    protected void writeSetToGeoJSON(Map<String, Set<JsonObject>> flags, File output) {
        JsonArray featureArray = new JsonArray();
        flags.values().stream().flatMap(Collection::stream).forEach(arg_0 -> ((JsonArray)featureArray).add(arg_0));
        JsonObject featureCollection = new JsonObject();
        featureCollection.add("type", (JsonElement)new JsonPrimitive(GeoJsonType.FEATURE_COLLECTION.toString()));
        featureCollection.add("features", (JsonElement)featureArray);
        JsonWriter writer = new JsonWriter((WritableResource)output);
        writer.writeLine(featureCollection);
        writer.close();
    }
}

