/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.atlas.predicates;

import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.EmbankmentTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LocationTag;
import org.openstreetmap.atlas.tags.ManMadeTag;
import org.openstreetmap.atlas.tags.MaxSpeedTag;
import org.openstreetmap.atlas.tags.MinSpeedTag;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.PowerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;

public interface TagPredicates {
    public static final Predicate<AtlasObject> IS_BUILDING = object -> Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{BuildingTag.class});
    public static final Predicate<AtlasObject> IS_ROOF = object -> Validators.isOfType((Taggable)object, BuildingTag.class, (Enum[])new BuildingTag[]{BuildingTag.ROOF});
    public static final Predicate<AtlasObject> IS_AREA = object -> Validators.isOfType((Taggable)object, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES});
    public static final Predicate<AtlasObject> IS_HIGHWAY_AREA = object -> Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{HighwayTag.class}) && Validators.isOfType((Taggable)object, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES});
    public static final Predicate<AtlasObject> HAS_SPEED_LIMIT = object -> Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{MaxSpeedTag.class}) || Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{MinSpeedTag.class});
    public static final Predicate<AtlasObject> IS_WATER_BODY = object -> Validators.isOfType((Taggable)object, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER});
    public static final Predicate<AtlasObject> IS_BRIDGE = object -> Validators.isOfType((Taggable)object, BridgeTag.class, (Enum[])new BridgeTag[]{BridgeTag.YES});
    public static final Predicate<AtlasObject> IS_EMBANKMENT = object -> Validators.isOfType((Taggable)object, EmbankmentTag.class, (Enum[])new EmbankmentTag[]{EmbankmentTag.YES});
    public static final Predicate<AtlasObject> IS_PIER = object -> Validators.isOfType((Taggable)object, ManMadeTag.class, (Enum[])new ManMadeTag[]{ManMadeTag.PIER});
    public static final Predicate<AtlasObject> IS_POWER_LINE = object -> Validators.isOfType((Taggable)object, PowerTag.class, (Enum[])new PowerTag[]{PowerTag.LINE});
    public static final Predicate<AtlasObject> GOES_UNDERWATER = object -> Validators.isOfType((Taggable)object, LocationTag.class, (Enum[])new LocationTag[]{LocationTag.UNDERWATER});
    public static final Predicate<AtlasObject> GOES_UNDERGROUND = object -> Validators.isOfType((Taggable)object, LocationTag.class, (Enum[])new LocationTag[]{LocationTag.UNDERGROUND});
    public static final Predicate<AtlasObject> IS_HIGHWAY_FOR_PEDESTRIANS = object -> Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.PEDESTRIAN, HighwayTag.FOOTWAY});
    public static final Predicate<AtlasObject> IS_CROSSING_HIGHWAY = object -> Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CROSSING});
}

