/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.EdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class EdgeCrossingEdgeCheck
extends BaseCheck<Long> {
    private static final String INSTRUCTION_FORMAT = "The road with id {0,number,#} has invalid crossings. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.";
    private static final String INVALID_EDGE_FORMAT = "Edge {0,number,#} is crossing invalidly.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The road with id {0,number,#} has invalid crossings. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.", "Edge {0,number,#} is crossing invalidly.");
    private static final String MINIMUM_HIGHWAY_DEFAULT = HighwayTag.NO.toString();
    private static final Long OSM_LAYER_DEFAULT = 0L;
    private static final long serialVersionUID = 2146863485833228593L;
    private final HighwayTag minimumHighwayType;

    private static boolean canCross(PolyLine edgeAsPolyLine, Optional<Long> edgeLayer, PolyLine crossingEdgeAsPolyLine, Optional<Long> crossingEdgeLayer, Location intersection) {
        return edgeAsPolyLine.contains(intersection) && crossingEdgeAsPolyLine.contains(intersection) || edgeLayer.isPresent() && crossingEdgeLayer.isPresent() && !edgeLayer.get().equals(crossingEdgeLayer.get());
    }

    public EdgeCrossingEdgeCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_DEFAULT, str -> Enum.valueOf(HighwayTag.class, str.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && this.isValidCrossingEdge(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set collectedEdges = new EdgeCrossingEdgeWalker((Edge)object, this.getInvalidCrossingEdges()).collectEdges();
        if (collectedEdges.size() > 1) {
            CheckFlag newFlag = new CheckFlag(this.getTaskIdentifier(object));
            this.markAsFlagged(object.getIdentifier());
            newFlag.addObject(object);
            newFlag.addInstruction(this.getLocalizedInstruction(0, object.getOsmIdentifier()));
            collectedEdges.forEach(invalidEdge -> {
                this.markAsFlagged(invalidEdge.getIdentifier());
                newFlag.addObject((AtlasObject)invalidEdge);
                newFlag.addInstruction(this.getLocalizedInstruction(1, invalidEdge.getOsmIdentifier()));
            });
            return Optional.of(newFlag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isValidCrossingEdge(AtlasObject object) {
        Optional highway;
        if (Edge.isMasterEdgeIdentifier((long)object.getIdentifier()) && !TagPredicates.IS_AREA.test(object) && !this.isFlagged(object.getIdentifier()) && (highway = HighwayTag.highwayTag((Taggable)object)).isPresent()) {
            HighwayTag highwayTag = (HighwayTag)highway.get();
            return HighwayTag.isCarNavigableHighway((HighwayTag)highwayTag) && !HighwayTag.CROSSING.equals((Object)highwayTag) && highwayTag.isMoreImportantThanOrEqualTo(this.minimumHighwayType);
        }
        return false;
    }

    private Function<Edge, Stream<Edge>> getInvalidCrossingEdges() {
        return edge -> {
            PolyLine edgeAsPolyLine = edge.asPolyLine();
            Rectangle edgeBounds = edge.bounds();
            Optional<Long> edgeLayer = Validators.hasValuesFor((Taggable)edge, (Class[])new Class[]{LayerTag.class}) ? LayerTag.getTaggedValue((Taggable)edge) : Optional.of(OSM_LAYER_DEFAULT);
            Atlas atlas = edge.getAtlas();
            return Iterables.asList((Iterable)atlas.edgesIntersecting((GeometricSurface)edgeBounds, crossingEdge -> edge.getIdentifier() != crossingEdge.getIdentifier() && this.isValidCrossingEdge((AtlasObject)crossingEdge))).stream().filter(crossingEdge -> {
                PolyLine crossingEdgeAsPolyLine = crossingEdge.asPolyLine();
                Optional<Long> crossingEdgeLayer = Validators.hasValuesFor((Taggable)crossingEdge, (Class[])new Class[]{LayerTag.class}) ? LayerTag.getTaggedValue((Taggable)crossingEdge) : Optional.of(OSM_LAYER_DEFAULT);
                return edgeAsPolyLine.intersections(crossingEdgeAsPolyLine).stream().anyMatch(intersection -> !EdgeCrossingEdgeCheck.canCross(edgeAsPolyLine, edgeLayer, crossingEdgeAsPolyLine, crossingEdgeLayer, intersection));
            });
        };
    }

    private class EdgeCrossingEdgeWalker
    extends EdgeWalker {
        EdgeCrossingEdgeWalker(Edge startingEdge, Function<Edge, Stream<Edge>> nextCandidates) {
            super(startingEdge, nextCandidates);
        }
    }
}

