/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteCommand;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.checks.maproulette.serializer.ChallengeDeserializer;
import org.openstreetmap.atlas.checks.maproulette.serializer.TaskDeserializer;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteUploadCommand
extends MapRouletteCommand {
    private static final Command.Switch<File> INPUT_DIRECTORY = new Command.Switch("logfiles", "Path to folder containing log files to upload to MapRoulette.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> CONFIG_LOCATION = new Command.Switch("config", "Path to a file containing MapRoulette challenge configuration.", File::new, Command.Optionality.OPTIONAL, "config/configuration.json");
    private static final Command.Switch<List<String>> COUNTRIES = new Command.Switch("countries", "A comma separated list of ISO3 country codes to filter flags by.", string -> Arrays.asList(string.split(",")), Command.Optionality.OPTIONAL);
    private static final Command.Switch<List<String>> CHECKS = new Command.Switch("checks", "A comma separated list of check names to filter flags by.", string -> Arrays.asList(string.split(",")), Command.Optionality.OPTIONAL);
    private static final String PARAMETER_CHALLENGE = "challenge";
    private static final String LOG_EXTENSION = "log";
    private static final String ZIPPED_LOG_EXTENSION = ".log.gz";
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteUploadCommand.class);
    private final Map<String, Challenge> checkNameChallengeMap = new HashMap<String, Challenge>();

    @Override
    protected void execute(CommandMap commandMap, MapRouletteConfiguration configuration) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Task.class, (Object)new TaskDeserializer(configuration.getProjectName())).create();
        Configuration instructions = this.loadConfiguration(commandMap);
        Optional countries = commandMap.getOption(COUNTRIES);
        Optional checks = commandMap.getOption(CHECKS);
        ((File)commandMap.get(INPUT_DIRECTORY)).listFilesRecursively().forEach(logFile -> {
            Optional<OutputFileType> optionalHandledFileType = this.getOptionalOutputType((File)logFile);
            optionalHandledFileType.ifPresent(outputFileType -> {
                try (BufferedReader reader = this.getReader((File)logFile, (OutputFileType)((Object)((Object)outputFileType)));){
                    reader.lines().forEach(line -> {
                        Task task = (Task)gson.fromJson(line, Task.class);
                        Optional countryCode = (Optional)Iterables.stream((Iterable)((Iterable)task.getGeoJson().orElse(new JsonArray()))).map(this::getElementCountryCode).firstMatching(Optional::isPresent).get();
                        String check = task.getChallengeName();
                        if ((!countries.isPresent() || countryCode.isPresent() && ((List)countries.get()).contains(countryCode.get())) && (!checks.isPresent() || ((List)checks.get()).contains(check))) {
                            try {
                                this.addTask(this.getChallenge(task.getChallengeName(), instructions), task);
                            }
                            catch (UnsupportedEncodingException | URISyntaxException error) {
                                logger.error("Exception thrown while adding task: ", (Throwable)error);
                            }
                        }
                    });
                    this.uploadTasks();
                }
                catch (IOException error) {
                    logger.error("Exception while reading {}:", logFile, (Object)error);
                }
            });
        });
    }

    private Optional<OutputFileType> getOptionalOutputType(File logFile) {
        if (logFile.getName().endsWith(ZIPPED_LOG_EXTENSION)) {
            return Optional.of(OutputFileType.COMPRESSED_LOG);
        }
        if (FilenameUtils.getExtension((String)logFile.getName()).equals(LOG_EXTENSION)) {
            return Optional.of(OutputFileType.LOG);
        }
        return Optional.empty();
    }

    private BufferedReader getReader(File inputFile, OutputFileType fileType) throws IOException {
        if (fileType == OutputFileType.LOG) {
            return new BufferedReader(new FileReader(inputFile.getPath()));
        }
        return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(inputFile.getPath()))));
    }

    private Configuration loadConfiguration(CommandMap map) {
        return new StandardConfiguration((Resource)((File)map.get(CONFIG_LOCATION)));
    }

    private String getChallengeParameter(String checkName) {
        return MessageFormat.format("{0}.{1}", checkName, PARAMETER_CHALLENGE);
    }

    private Challenge getChallenge(String checkName, Configuration fallbackConfiguration) {
        return this.checkNameChallengeMap.computeIfAbsent(checkName, name -> {
            Map challengeMap = (Map)fallbackConfiguration.get(this.getChallengeParameter(checkName), Collections.emptyMap()).value();
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Challenge.class, (Object)new ChallengeDeserializer()).create();
            Challenge result = (Challenge)gson.fromJson(gson.toJson((Object)challengeMap), Challenge.class);
            result.setName(checkName);
            return result;
        });
    }

    private Optional<String> getElementCountryCode(JsonElement element) {
        JsonObject properties;
        JsonObject elementJson = element.getAsJsonObject();
        if (elementJson.has("properties") && (properties = elementJson.get("properties").getAsJsonObject()).has("iso_country_code")) {
            return Optional.of(properties.get("iso_country_code").getAsString());
        }
        return Optional.empty();
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(new Command.Switch[]{INPUT_DIRECTORY, CONFIG_LOCATION, COUNTRIES, CHECKS});
    }

    public static void main(String[] args) {
        new MapRouletteUploadCommand().run(args);
    }

    private static enum OutputFileType {
        LOG,
        COMPRESSED_LOG;

    }
}

