/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public abstract class JSONFlagDiffSubCommand
implements FlexibleSubCommand {
    private static final Command.Switch<File> SOURCE_FILE_PARAMETER = new Command.Switch("source", "A file or directory of files containing atlas-checks flags to compare changes from.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> TARGET_FILE_PARAMETER = new Command.Switch("target", "A file or directory of files containing atlas-checks flags to compare changes to.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<String> OUTPUT_FOLDER_PARAMETER = new Command.Switch("output", "A directory to place output log files in. If not included no outputs files will be written.", String::new, Command.Optionality.OPTIONAL);
    static final String FEATURE_COLLECTION = "FeatureCollection";
    static final String FEATURE_PROPERTIES = "feature_properties";
    static final String FEATURES = "features";
    static final String GENERATOR = "generator";
    static final String ID = "id";
    static final String ITEM_ID = "ItemId";
    static final String PROPERTIES = "properties";
    static final String TYPE = "type";
    private final Gson gson = new Gson();
    private final HashMap source = new HashMap();
    private final HashMap target = new HashMap();
    private String name;
    private String description;
    private String fileExtension;

    public JSONFlagDiffSubCommand(String name, String description, String fileExtension) {
        this.name = name;
        this.description = description;
        this.fileExtension = fileExtension;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{SOURCE_FILE_PARAMETER, TARGET_FILE_PARAMETER, OUTPUT_FOLDER_PARAMETER});
    }

    public void usage(PrintStream writer) {
        writer.print("-source=path/to/first/flag/file,path/to/second/flag/file : file of flags to compare changes from\n");
        writer.print("-target=path/to/first/flag/file,path/to/second/flag/file : file of flags to compare changes to\n");
        writer.print("-output=path/to/output/folder : optional directory to write output files to\n");
    }

    public int execute(CommandMap command) {
        this.getFilesOfType((File)command.get(SOURCE_FILE_PARAMETER)).forEach(path -> this.mapFeatures((File)path, this.source));
        this.getFilesOfType((File)command.get(TARGET_FILE_PARAMETER)).forEach(path -> this.mapFeatures((File)path, this.target));
        HashSet<JsonObject> additions = this.getDiff(this.target, this.source, DiffReturn.MISSING).getMissing();
        JSONFlagDiff subAndChange = this.getDiff(this.source, this.target, DiffReturn.CHANGED);
        HashSet<JsonObject> subtractions = subAndChange.getMissing();
        HashSet<JsonObject> changes = subAndChange.getChanged();
        System.out.printf("\n Total Items: %d\n   Additions: %d\n     Changes: %d\nSubtractions: %d\n", this.getSourceSize() + additions.size(), additions.size(), changes.size(), subtractions.size());
        Optional output = command.getOption(OUTPUT_FOLDER_PARAMETER);
        if (output.isPresent()) {
            this.writeSetToGeoJSON(additions, new File(String.format("%s/additions-%d-%d.%s", output.get(), new Date().getTime(), additions.size(), this.fileExtension)));
            this.writeSetToGeoJSON(changes, new File(String.format("%s/changes-%d-%d.%s", output.get(), new Date().getTime(), changes.size(), this.fileExtension)));
            this.writeSetToGeoJSON(subtractions, new File(String.format("%s/subtractions-%d-%d.%s", output.get(), new Date().getTime(), subtractions.size(), this.fileExtension)));
        }
        return 0;
    }

    private Set<File> getFilesOfType(File file) {
        String fileName;
        String string = fileName = file.isGzipped() ? FilenameUtils.getBaseName((String)file.getName()) : file.getName();
        if (FilenameUtils.getExtension((String)fileName).equalsIgnoreCase(this.fileExtension)) {
            return Collections.singleton(file);
        }
        if (file.isDirectory()) {
            return file.listFilesRecursively().stream().filter(this::checkFileExtension).collect(Collectors.toSet());
        }
        return new HashSet<File>();
    }

    private boolean checkFileExtension(File file) {
        return FilenameUtils.getExtension((String)(file.isGzipped() ? FilenameUtils.getBaseName((String)file.getName()) : file.getName())).equalsIgnoreCase(this.fileExtension);
    }

    protected void mapFeatures(File file, HashMap map) {
    }

    protected JSONFlagDiff getDiff(HashMap source, HashMap target, DiffReturn returnType) {
        return new JSONFlagDiff();
    }

    protected boolean identicalFeatureIds(JsonArray sourceArray, JsonArray targetArray) {
        return true;
    }

    protected void writeSetToGeoJSON(Set<JsonObject> flags, File output) {
        JsonWriter writer = new JsonWriter((WritableResource)output);
        flags.forEach(arg_0 -> ((JsonWriter)writer).writeLine(arg_0));
        writer.close();
    }

    protected int getSourceSize() {
        return this.source.size();
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected HashMap getSource() {
        return this.source;
    }

    protected HashMap getTarget() {
        return this.target;
    }

    protected class JSONFlagDiff {
        private final HashSet<JsonObject> missing = new HashSet();
        private final HashSet<JsonObject> changed = new HashSet();

        protected JSONFlagDiff() {
        }

        public void addMissing(JsonObject object) {
            this.missing.add(object);
        }

        public void addChanged(JsonObject object) {
            this.changed.add(object);
        }

        public HashSet<JsonObject> getMissing() {
            return this.missing;
        }

        public HashSet<JsonObject> getChanged() {
            return this.changed;
        }
    }

    protected static enum DiffReturn {
        MISSING,
        CHANGED;

    }
}

