/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.atlas.checks.commands.JSONFlagDiffSubCommand;
import org.openstreetmap.atlas.checks.configuration.ConfigurationResolver;
import org.openstreetmap.atlas.streaming.resource.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasChecksLogDiffSubCommand
extends JSONFlagDiffSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationResolver.class);

    public AtlasChecksLogDiffSubCommand() {
        super("log-diff", "Takes 2 sets of atlas-checks log flag files and reports the number of additions, subtractions, and changed flags from source to target.", "log");
    }

    @Override
    protected void mapFeatures(File file, HashMap map) {
        try (InputStreamReader inputStreamReader = file.isGzipped() ? new InputStreamReader(new GZIPInputStream(new FileInputStream(file.getFile()))) : new FileReader(file.getPath());
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                JsonObject source = (JsonObject)this.getGson().fromJson(line, JsonObject.class);
                String checkName = source.get("properties").getAsJsonObject().get("generator").getAsString();
                if (!map.containsKey(checkName)) {
                    map.put(checkName, new HashMap());
                }
                ((HashMap)map.get(checkName)).put(source.get("properties").getAsJsonObject().get("id").getAsString(), source);
            }
        }
        catch (IOException exception) {
            logger.warn("File read failed with exception", (Throwable)exception);
        }
    }

    @Override
    protected JSONFlagDiffSubCommand.JSONFlagDiff getDiff(HashMap source, HashMap target, JSONFlagDiffSubCommand.DiffReturn returnType) {
        JSONFlagDiffSubCommand.JSONFlagDiff diff = new JSONFlagDiffSubCommand.JSONFlagDiff(this);
        source.forEach((check, flag) -> ((HashMap)flag).forEach((identifier, featureCollection) -> {
            if (!target.containsKey(check) || !((HashMap)target.get(check)).containsKey(identifier)) {
                diff.addMissing((JsonObject)featureCollection);
            } else if (returnType.equals((Object)JSONFlagDiffSubCommand.DiffReturn.CHANGED) && !this.identicalFeatureIds(featureCollection.get("features").getAsJsonArray(), ((JsonObject)((HashMap)target.get(check)).get(identifier)).get("features").getAsJsonArray())) {
                diff.addChanged((JsonObject)featureCollection);
            }
        }));
        return diff;
    }

    @Override
    protected boolean identicalFeatureIds(JsonArray sourceArray, JsonArray targetArray) {
        ArrayList sourceIds = new ArrayList();
        ArrayList targetIds = new ArrayList();
        if (sourceArray.size() != targetArray.size()) {
            return false;
        }
        sourceArray.forEach(object -> {
            if (object.getAsJsonObject().get("properties").getAsJsonObject().has("ItemId")) {
                sourceIds.add(object.getAsJsonObject().get("properties").getAsJsonObject().get("ItemId").getAsString());
            }
        });
        targetArray.forEach(object -> {
            if (object.getAsJsonObject().get("properties").getAsJsonObject().has("ItemId")) {
                targetIds.add(object.getAsJsonObject().get("properties").getAsJsonObject().get("ItemId").getAsString());
            }
        });
        return sourceIds.containsAll(targetIds) && targetIds.containsAll(sourceIds);
    }

    @Override
    protected int getSourceSize() {
        int sourceSize = 0;
        for (String check : this.getSource().keySet()) {
            sourceSize += ((HashMap)this.getSource().get(check)).size();
        }
        return sourceSize;
    }
}

