/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.atlas.checks.commands.JSONFlagDiffSubCommand;
import org.openstreetmap.atlas.checks.configuration.ConfigurationResolver;
import org.openstreetmap.atlas.streaming.resource.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasChecksGeoJSONDiffSubCommand
extends JSONFlagDiffSubCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationResolver.class);

    public AtlasChecksGeoJSONDiffSubCommand() {
        super("geojson-diff", "Takes 2 sets of atlas-checks geoJSON flag files and reports the number of additions, subtractions, and changed flags from source to target.", "geojson");
    }

    @Override
    protected void mapFeatures(File file, HashMap map) {
        try (InputStream inputStream = file.isGzipped() ? new GZIPInputStream(new FileInputStream(file.getFile())) : file.read();){
            JsonObject json = (JsonObject)this.getGson().fromJson(new JsonReader((Reader)new InputStreamReader(inputStream)), JsonObject.class);
            json.get("features").getAsJsonArray().forEach(feature -> map.put(feature.getAsJsonObject().get("id").getAsString(), feature.getAsJsonObject()));
        }
        catch (IOException exception) {
            logger.warn("File read failed with exception", (Throwable)exception);
        }
    }

    @Override
    protected JSONFlagDiffSubCommand.JSONFlagDiff getDiff(HashMap source, HashMap target, JSONFlagDiffSubCommand.DiffReturn returnType) {
        JSONFlagDiffSubCommand.JSONFlagDiff diff = new JSONFlagDiffSubCommand.JSONFlagDiff();
        source.forEach((identifier, feature) -> {
            if (!target.containsKey(identifier)) {
                diff.addMissing((JsonObject)feature);
            } else if (returnType.equals((Object)JSONFlagDiffSubCommand.DiffReturn.CHANGED) && !this.identicalFeatureIds(((JsonObject)feature).get("properties").getAsJsonObject().get("feature_properties").getAsJsonArray(), ((JsonObject)target.get(identifier)).getAsJsonObject().get("properties").getAsJsonObject().get("feature_properties").getAsJsonArray())) {
                diff.addChanged((JsonObject)feature);
            }
        });
        return diff;
    }

    @Override
    protected boolean identicalFeatureIds(JsonArray sourceArray, JsonArray targetArray) {
        ArrayList sourceIds = new ArrayList();
        ArrayList targetIds = new ArrayList();
        sourceArray.forEach(object -> {
            if (object.getAsJsonObject().has("ItemId")) {
                sourceIds.add(object.getAsJsonObject().get("ItemId").getAsString());
            }
        });
        targetArray.forEach(object -> {
            if (object.getAsJsonObject().has("ItemId")) {
                targetIds.add(object.getAsJsonObject().get("ItemId").getAsString());
            }
        });
        return sourceIds.containsAll(targetIds) && targetIds.containsAll(sourceIds);
    }

    @Override
    protected void writeSetToGeoJSON(Set<JsonObject> flags, File output) {
        JsonArray featureArray = new JsonArray();
        flags.forEach(arg_0 -> ((JsonArray)featureArray).add(arg_0));
        JsonObject featureCollection = new JsonObject();
        featureCollection.add("type", (JsonElement)new JsonPrimitive("FeatureCollection"));
        featureCollection.add("features", (JsonElement)featureArray);
        super.writeSetToGeoJSON(Collections.singleton(featureCollection), output);
    }
}

