/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.tee.v0_6;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkMultiSource;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;
import org.openstreetmap.osmosis.core.task.v0_6.Source;

public class EntityTee
implements SinkMultiSource {
    private List<ProxySinkSource> sinkList = new ArrayList<ProxySinkSource>();

    public EntityTee(int outputCount) {
        for (int i = 0; i < outputCount; ++i) {
            this.sinkList.add(new ProxySinkSource());
        }
    }

    @Override
    public Source getSource(int index) {
        if (index < 0 || index >= this.sinkList.size()) {
            throw new OsmosisRuntimeException("Source index " + index + " is in the range 0 to " + (this.sinkList.size() - 1) + ".");
        }
        return this.sinkList.get(index);
    }

    @Override
    public int getSourceCount() {
        return this.sinkList.size();
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        for (ProxySinkSource sink : this.sinkList) {
            sink.initialize(metaData);
        }
    }

    @Override
    public void process(EntityContainer entityContainer) {
        for (ProxySinkSource sink : this.sinkList) {
            entityContainer.getEntity().makeReadOnly();
            sink.process(entityContainer);
        }
    }

    @Override
    public void complete() {
        for (ProxySinkSource sink : this.sinkList) {
            sink.complete();
        }
    }

    @Override
    public void release() {
        for (ProxySinkSource sink : this.sinkList) {
            sink.release();
        }
    }

    private static class ProxySinkSource
    implements SinkSource {
        private Sink sink;

        @Override
        public void setSink(Sink sink) {
            this.sink = sink;
        }

        @Override
        public void initialize(Map<String, Object> metaData) {
            this.sink.initialize(metaData);
        }

        @Override
        public void process(EntityContainer entityContainer) {
            this.sink.process(entityContainer);
        }

        @Override
        public void complete() {
            this.sink.complete();
        }

        @Override
        public void release() {
            this.sink.release();
        }
    }
}

